/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.util.LogicHelper;

public class TagPreference<T extends IForgeRegistryEntry<T>> {
    private static final ResourceLocation DEFAULT_ID = new ResourceLocation("zzzzz:zzzzz");
    private static final Map<Class<?>, TagPreference<?>> PREFERENCE_MAP = new IdentityHashMap();
    private static final Supplier<ITagCollection<Item>> ITEM_TAG_COLLECTION_SUPPLIER = () -> TagCollectionManager.func_242178_a().func_241836_b();
    private static final Supplier<ITagCollection<Fluid>> FLUID_TAG_COLLECTION_SUPPLIER = () -> TagCollectionManager.func_242178_a().func_241837_c();
    private static final Comparator<IForgeRegistryEntry<?>> ENTRY_COMPARATOR = (a, b) -> {
        int indexB;
        ResourceLocation idA = LogicHelper.defaultIfNull(a.getRegistryName(), DEFAULT_ID);
        ResourceLocation idB = LogicHelper.defaultIfNull(b.getRegistryName(), DEFAULT_ID);
        List<? extends String> entries = Config.TAG_PREFERENCES.get();
        int size = entries.size();
        int indexA = LogicHelper.defaultIf(entries.indexOf(idA.func_110624_b()), -1, size);
        if (indexA != (indexB = LogicHelper.defaultIf(entries.indexOf(idB.func_110624_b()), -1, size))) {
            return Integer.compare(indexA, indexB);
        }
        return idA.compareNamespaced(idB);
    };
    private final Supplier<ITagCollection<T>> collection;
    private final Map<ResourceLocation, Optional<T>> preferenceCache = new HashMap<ResourceLocation, Optional<T>>();

    public static <T extends IForgeRegistryEntry<T>> TagPreference<T> getInstance(Class<T> clazz, Supplier<ITagCollection<T>> collection) {
        return PREFERENCE_MAP.computeIfAbsent(clazz, c -> new TagPreference(collection));
    }

    public static TagPreference<Item> getItems() {
        return TagPreference.getInstance(Item.class, ITEM_TAG_COLLECTION_SUPPLIER);
    }

    public static TagPreference<Fluid> getFluids() {
        return TagPreference.getInstance(Fluid.class, FLUID_TAG_COLLECTION_SUPPLIER);
    }

    private TagPreference(Supplier<ITagCollection<T>> collection) {
        this.collection = collection;
        MinecraftForge.EVENT_BUS.addListener(this::clearCache);
    }

    private void clearCache(TagsUpdatedEvent.VanillaTagTypes event) {
        this.preferenceCache.clear();
    }

    private Optional<T> getUncachedPreference(ITag<T> tag) {
        if (tag instanceof Tags.IOptionalNamedTag && ((Tags.IOptionalNamedTag)tag).isDefaulted()) {
            return Optional.empty();
        }
        List elements = tag.func_230236_b_();
        if (elements.isEmpty()) {
            return Optional.empty();
        }
        if (elements.size() == 1) {
            return Optional.of(elements.get(0));
        }
        return elements.stream().min(ENTRY_COMPARATOR).map(t -> t);
    }

    public Optional<T> getPreference(ITag<T> tag) {
        try {
            ResourceLocation tagName = this.collection.get().func_232975_b_(tag);
            return this.preferenceCache.computeIfAbsent(tagName, name -> this.getUncachedPreference(tag));
        }
        catch (Exception e) {
            Mantle.logger.warn("Attempting to get tag preference for unregistered tag {}", tag, (Object)e);
            return this.getUncachedPreference(tag);
        }
    }
}

