/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class EnumObject<T extends Enum<T>, I extends IForgeRegistryEntry<? super I>> {
    private static final EnumObject EMPTY = new EnumObject(Collections.emptyMap());
    private final Map<T, Supplier<? extends I>> map;

    @Nullable
    public Supplier<? extends I> getSupplier(T value) {
        return this.map.get(value);
    }

    public I get(T value) {
        Supplier<I> supplier = this.map.get(value);
        if (supplier == null) {
            throw new NoSuchElementException("Missing key " + value);
        }
        return (I)((IForgeRegistryEntry)Objects.requireNonNull(supplier.get(), () -> "No enum object value for " + value));
    }

    @Nullable
    public I getOrNull(T value) {
        Supplier<I> supplier = this.map.get(value);
        if (supplier == null) {
            return null;
        }
        try {
            return (I)((IForgeRegistryEntry)supplier.get());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public boolean contains(IForgeRegistryEntry<? super I> value) {
        return this.map.values().stream().map(Supplier::get).anyMatch(value::equals);
    }

    public List<I> values() {
        return this.map.values().stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void forEach(BiConsumer<T, ? super I> consumer) {
        this.map.forEach((? super K key, ? super V sup) -> {
            IForgeRegistryEntry value;
            try {
                value = (IForgeRegistryEntry)sup.get();
            }
            catch (NullPointerException e) {
                return;
            }
            if (value != null) {
                consumer.accept((Object)key, (Object)value);
            }
        });
    }

    public void forEach(Consumer<? super I> consumer) {
        this.forEach((T k, ? super I v) -> consumer.accept((Object)v));
    }

    public static <T extends Enum<T>, I extends IForgeRegistryEntry<? super I>> EnumObject<T, I> empty() {
        return EMPTY;
    }

    protected EnumObject(Map<T, Supplier<? extends I>> map) {
        this.map = map;
    }

    public static class Builder<T extends Enum<T>, I extends IForgeRegistryEntry<? super I>> {
        private final Map<T, Supplier<? extends I>> map;

        public Builder(Class<T> clazz) {
            this.map = new EnumMap<T, Supplier<? extends I>>(clazz);
        }

        public Builder<T, I> put(T key, Supplier<? extends I> value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<T, I> putDelegate(T key, IRegistryDelegate<? super I> value) {
            this.map.put(key, () -> (IForgeRegistryEntry)value.get());
            return this;
        }

        public Builder<T, I> putAll(Map<T, Supplier<? extends I>> map) {
            this.map.putAll(map);
            return this;
        }

        public Builder<T, I> putAll(EnumObject<T, ? extends I> object) {
            this.map.putAll(((EnumObject)object).map);
            return this;
        }

        public EnumObject<T, I> build() {
            return new EnumObject<T, I>(this.map);
        }
    }
}

