/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;

public class PlayerHelpers {
    private static final Map<ServerWorld, FakePlayer> FAKE_PLAYERS = new WeakHashMap<ServerWorld, FakePlayer>();

    public static FakePlayer getFakePlayer(ServerWorld world) {
        FakePlayer fakePlayer = FAKE_PLAYERS.get(world);
        if (fakePlayer == null) {
            fakePlayer = new ExtendedFakePlayer(world);
            FAKE_PLAYERS.put(world, fakePlayer);
        }
        return fakePlayer;
    }

    public static void setPlayerState(PlayerEntity player, Hand hand, BlockPos pos, double offsetX, double offsetY, double offsetZ, Direction side, boolean sneaking) {
        offsetY = side == Direction.DOWN ? -offsetY : offsetY;
        player.func_70107_b((double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ);
        player.field_70169_q = player.func_226277_ct_();
        player.field_70167_r = player.func_226278_cu_();
        player.field_70166_s = player.func_226281_cx_();
        player.field_70177_z = side.func_176734_d().func_185119_l();
        player.field_70125_A = side == Direction.UP ? 90.0f : (side == Direction.DOWN ? -90.0f : 0.0f);
        player.field_213326_aJ = 0.0f;
        player.func_226284_e_(sneaking);
        PlayerHelpers.setHeldItemSilent(player, hand, ItemStack.field_190927_a);
        player.func_70071_h_();
        player.func_230245_c_(true);
    }

    public static void setHeldItemSilent(PlayerEntity player, Hand hand, ItemStack itemStack) {
        if (hand == Hand.MAIN_HAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
        } else if (hand == Hand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
        } else {
            player.func_184611_a(hand, itemStack);
        }
    }
}

