/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class WireApi {
    public static final Map<WireType, FeedthroughModelInfo> INFOS = new HashMap<WireType, FeedthroughModelInfo>();
    public static final Map<String, Set<WireType>> WIRES_BY_CATEGORY = new HashMap<String, Set<WireType>>();

    public static void registerFeedthroughForWiretype(WireType w, ResourceLocation texLoc, float[] uvs, double connLength, Supplier<BlockState> conn) {
        INFOS.put(w, new FeedthroughModelInfo(texLoc, uvs, connLength, connLength, conn));
    }

    public static void registerFeedthroughForWiretype(WireType w, ResourceLocation texLoc, float[] uvs, double connLength, double connOffset, Supplier<BlockState> conn) {
        INFOS.put(w, new FeedthroughModelInfo(texLoc, uvs, connLength, connOffset, conn));
    }

    @Nullable
    public static WireType getWireType(BlockState state) {
        for (Map.Entry<WireType, FeedthroughModelInfo> entry : INFOS.entrySet()) {
            if (!entry.getValue().isValidConnector(state)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void registerWireType(WireType w) {
        String category = w.getCategory();
        if (category != null) {
            if (!WIRES_BY_CATEGORY.containsKey(category)) {
                WIRES_BY_CATEGORY.put(category, new HashSet());
            }
            WIRES_BY_CATEGORY.get(category).add(w);
        }
    }

    public static boolean canMix(WireType a, WireType b) {
        String cat = a.getCategory();
        return cat != null && cat.equals(b.getCategory());
    }

    public static Set<WireType> getWiresForType(@Nullable String category) {
        if (category == null) {
            return ImmutableSet.of();
        }
        return WIRES_BY_CATEGORY.get(category);
    }

    public static class FeedthroughModelInfo {
        public Supplier<BlockState> conn;
        final ResourceLocation texLoc;
        @OnlyIn(value=Dist.CLIENT)
        public TextureAtlasSprite tex;
        public final double[] uvs = new double[4];
        public final double connLength;
        public final double connOffset;

        public FeedthroughModelInfo(ResourceLocation texLoc, float[] uvs, double connLength, double connOffset, Supplier<BlockState> conn) {
            this.texLoc = texLoc;
            for (int i = 0; i < 4; ++i) {
                this.uvs[i] = uvs[i];
            }
            this.connLength = connLength;
            this.connOffset = connOffset;
            this.conn = conn;
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake));
        }

        public boolean isValidConnector(BlockState state) {
            BlockState conn = this.conn.get();
            if (state.func_177230_c() != conn.func_177230_c()) {
                return false;
            }
            for (Property p : state.func_235904_r_()) {
                if (p == IEProperties.FACING_ALL || p == BlockStateProperties.field_208198_y || state.func_177229_b(p).equals(conn.func_177229_b(p))) continue;
                return false;
            }
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onModelBake(ModelBakeEvent evt) {
            this.tex = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(this.texLoc);
        }
    }
}

