/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleAVLTreeSet;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class CatenaryTracer {
    private final Connection.CatenaryData catenaryData;
    private final BlockPos offset;
    @VisibleForTesting
    public DoubleSortedSet integerIntersections = null;

    public CatenaryTracer(Connection.CatenaryData catenaryData, BlockPos offset) {
        this.catenaryData = catenaryData;
        this.offset = offset;
    }

    public static double acosh(double arg, CatenaryBranch branch) {
        double factor = branch == CatenaryBranch.NEGATIVE ? -1.0 : 1.0;
        return Math.log(arg + factor * Math.sqrt(arg * arg - 1.0));
    }

    public void calculateIntegerIntersections() {
        double min;
        this.integerIntersections = new DoubleAVLTreeSet();
        Vector3d across = this.catenaryData.getDelta();
        Vector3d start = this.catenaryData.getVecA();
        Vector3d end = start.func_178787_e(this.catenaryData.getDelta());
        across = new Vector3d(across.field_72450_a, 0.0, across.field_72449_c);
        double lengthHor = across.func_72433_c();
        this.integerIntersections.add(0.0);
        this.integerIntersections.add(1.0);
        for (int dim = 0; dim <= 2; dim += 2) {
            int startCoord = (int)Math.ceil(Math.min(ApiUtils.getDim(start, dim), ApiUtils.getDim(end, dim)));
            int endCoord = (int)Math.floor(Math.max(ApiUtils.getDim(start, dim), ApiUtils.getDim(end, dim)));
            for (int i = startCoord; i <= endCoord; ++i) {
                double factor = ((double)i - ApiUtils.getDim(start, dim)) / ApiUtils.getDim(across, dim);
                this.integerIntersections.add(factor);
            }
        }
        if (this.catenaryData.isVertical()) {
            min = Math.min(start.field_72448_b, end.field_72448_b);
            double max = Math.max(start.field_72448_b, end.field_72448_b);
            int y = (int)Math.ceil(min);
            while ((double)y <= Math.floor(max)) {
                double factor = ((double)y - min) / (max - min);
                this.integerIntersections.add(factor);
                ++y;
            }
        } else {
            min = !CatenaryBranch.POSITIVE.exists(this.catenaryData) || !CatenaryBranch.NEGATIVE.exists(this.catenaryData) ? Math.min(start.field_72448_b, end.field_72448_b) : this.catenaryData.getScale() + this.catenaryData.getOffsetY() + start.field_72448_b;
            for (CatenaryBranch branch : CatenaryBranch.values()) {
                if (!branch.exists(this.catenaryData)) continue;
                double max = branch == CatenaryBranch.POSITIVE ? end.field_72448_b : start.field_72448_b;
                for (int y = MathHelper.func_76143_f((double)min); y <= MathHelper.func_76128_c((double)max); ++y) {
                    double yReal = (double)y - start.field_72448_b;
                    double acosh = CatenaryTracer.acosh((yReal - this.catenaryData.getOffsetY()) / this.catenaryData.getScale(), branch);
                    double posRel = (acosh * this.catenaryData.getScale() + this.catenaryData.getOffsetX()) / lengthHor;
                    Preconditions.checkState((posRel >= -1.0E-5 && posRel <= 1.00001 ? 1 : 0) != 0);
                    if (!(posRel >= 0.0) || !(posRel <= 1.0)) continue;
                    this.integerIntersections.add(posRel);
                }
            }
        }
        double last = 0.0;
        DoubleBidirectionalIterator it = this.integerIntersections.iterator();
        while (it.hasNext()) {
            double current = it.nextDouble();
            if (current > 0.0 && current - last < 1.0E-5) {
                it.remove();
                continue;
            }
            last = current;
        }
    }

    @VisibleForTesting
    public void forEachCloseCoordinate(Vector3d coord, double eps, Consumer<BlockPos> out) {
        for (int x = MathHelper.func_76128_c((double)(coord.field_72450_a - eps)); x < MathHelper.func_76143_f((double)(coord.field_72450_a + eps)); ++x) {
            for (int y = MathHelper.func_76128_c((double)(coord.field_72448_b - eps)); y < MathHelper.func_76143_f((double)(coord.field_72448_b + eps)); ++y) {
                for (int z = MathHelper.func_76128_c((double)(coord.field_72449_c - eps)); z < MathHelper.func_76143_f((double)(coord.field_72449_c + eps)); ++z) {
                    out.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    public void forEachSegment(Consumer<Segment> out) {
        double epsilonIn = 1.0E-5;
        double epsilonNear = 0.3;
        DoubleBidirectionalIterator it = this.integerIntersections.iterator();
        Vector3d last = this.catenaryData.getPoint(it.nextDouble());
        while (it.hasNext()) {
            Vector3d next = this.catenaryData.getPoint(it.nextDouble());
            HashSet<BlockPos> in = new HashSet<BlockPos>();
            HashSet<BlockPos> near = new HashSet<BlockPos>();
            for (Vector3d pos : new Vector3d[]{last, next}) {
                this.forEachCloseCoordinate(pos, 1.0E-5, in::add);
                this.forEachCloseCoordinate(pos, 0.3, near::add);
            }
            near.removeAll(in);
            this.processSegments(in, last, next, true, out);
            this.processSegments(near, last, next, false, out);
            last = next;
        }
    }

    private void processSegments(Set<BlockPos> positions, Vector3d start, Vector3d end, boolean in, Consumer<Segment> out) {
        for (BlockPos p : positions) {
            Vector3d posVec = new Vector3d((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
            Vector3d startRel = start.func_178788_d(posVec);
            Vector3d endRel = end.func_178788_d(posVec);
            BlockPos realPos = p.func_177971_a((Vector3i)this.offset);
            out.accept(new Segment(startRel, endRel, realPos, in));
        }
    }

    private static enum CatenaryBranch {
        POSITIVE,
        NEGATIVE;


        boolean exists(Connection.CatenaryData data) {
            if (this == NEGATIVE) {
                return data.getOffsetX() >= 0.0;
            }
            return data.getOffsetX() <= data.getHorLength();
        }
    }

    public static class Segment {
        public final Vector3d relativeSegmentStart;
        public final Vector3d relativeSegmentEnd;
        public final BlockPos mainPos;
        public final boolean inBlock;

        public Segment(Vector3d relativeSegmentStart, Vector3d relativeSegmentEnd, BlockPos mainPos, boolean inBlock) {
            this.relativeSegmentStart = relativeSegmentStart;
            this.relativeSegmentEnd = relativeSegmentEnd;
            this.mainPos = mainPos;
            this.inBlock = inBlock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.inBlock == segment.inBlock && this.relativeSegmentStart.equals((Object)segment.relativeSegmentStart) && this.relativeSegmentEnd.equals((Object)segment.relativeSegmentEnd) && this.mainPos.equals((Object)segment.mainPos);
        }

        public int hashCode() {
            return Objects.hash(this.relativeSegmentStart, this.relativeSegmentEnd, this.mainPos, this.inBlock);
        }
    }
}

