/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SheetmetalTankTileEntity
extends MultiblockPartTileEntity<SheetmetalTankTileEntity>
implements IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockBounds {
    public FluidTank tank = new FluidTank(512000);
    private final LayeredComparatorOutput comparatorHelper = new LayeredComparatorOutput(this.tank.getCapacity(), 4, () -> this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c()), layer -> {
        BlockPos masterPos = this.field_174879_c.func_177973_b((Vector3i)this.offsetToMaster);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos = masterPos.func_177982_a(x, layer + 1, z);
                this.field_145850_b.func_195593_d(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
            }
        }
    });
    private final List<CapabilityReference<IFluidHandler>> fluidNeighbors = new ArrayList<CapabilityReference<IFluidHandler>>();
    private static final BlockPos ioTopOffset = new BlockPos(1, 4, 1);
    private static final BlockPos ioBottomOffset = new BlockPos(1, 0, 1);
    private static final Set<BlockPos> ioOffsets = ImmutableSet.of((Object)ioTopOffset, (Object)ioBottomOffset);
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;

    public SheetmetalTankTileEntity() {
        super(IEMultiblocks.SHEETMETAL_TANK, (TileEntityType)IETileTypes.SHEETMETAL_TANK.get(), true);
        this.redstoneControlInverted = true;
        for (Direction f : DirectionUtils.VALUES) {
            if (f == Direction.UP) continue;
            this.fluidNeighbors.add(CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f));
        }
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.func_184586_b(Hand.MAIN_HAND))) {
            SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
            FluidStack fs = master != null ? master.tank.getFluid() : this.tank.getFluid();
            return new ITextComponent[]{TextUtils.formatFluidStack(fs)};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.isDummy() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isRSDisabled()) {
            for (CapabilityReference<IFluidHandler> outputRef : this.fluidNeighbors) {
                int accepted;
                if (this.tank.getFluidAmount() <= 0) continue;
                int outSize = Math.min(144, this.tank.getFluidAmount());
                FluidStack out = Utils.copyFluidStackWithAmount(this.tank.getFluid(), outSize, false);
                IFluidHandler output = outputRef.getNullable();
                if (output == null || (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                this.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                this.markContainingBlockForUpdate(null);
            }
        }
        this.comparatorHelper.update(this.tank.getFluidAmount());
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (this.posInMultiblock.func_177958_n() % 2 == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177952_p() % 2 == 0) {
            return VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (master != null && ioOffsets.contains(this.posInMultiblock)) {
            return new FluidTank[]{master.tank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return ioOffsets.contains(this.posInMultiblock);
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return ioBottomOffset.equals((Object)this.posInMultiblock);
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (master != null && FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)master.tank)) {
            this.updateMasterBlock(null, true);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offsetToMaster.equals((Object)BlockPos.field_177992_a) ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 5, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @Override
    public int getComparatorInputOverride() {
        if (ioBottomOffset.equals((Object)this.posInMultiblock)) {
            return this.comparatorHelper.getCurrentMasterOutput();
        }
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (this.offsetToMaster.func_177956_o() >= 1 && master != null) {
            return master.comparatorHelper.getLayerOutput(this.offsetToMaster.func_177956_o() - 1);
        }
        return 0;
    }
}

