/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.RecipeMatcher;

public class ShapelessFluidAwareRecipe
extends AbstractFluidAwareRecipe<MatchLocation> {
    public ShapelessFluidAwareRecipe(ResourceLocation idIn, String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeItemsIn, recipeOutputIn);
    }

    public ShapelessFluidAwareRecipe(ShapelessRecipe in) {
        this(in.func_199560_c(), in.func_193358_e(), (NonNullList<Ingredient>)in.func_192400_c(), in.func_77571_b());
    }

    @Override
    @Nullable
    protected MatchLocation findMatch(CraftingInventory inv) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int[] slotToInput = new int[inv.func_70302_i_()];
        Arrays.fill(slotToInput, -1);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            slotToInput[i] = inputs.size();
            inputs.add(itemstack);
        }
        if (inputs.size() != this.func_192400_c().size()) {
            return null;
        }
        int[] matchMap = RecipeMatcher.findMatches(inputs, this.func_192400_c());
        if (matchMap == null) {
            return null;
        }
        int[][] slotToIngredient = new int[inv.func_174922_i()][inv.func_174923_h()];
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                int inputId = slotToInput[x + inv.func_174922_i() * y];
                slotToIngredient[x][y] = inputId >= 0 ? matchMap[inputId] : -1;
            }
        }
        return new MatchLocation(slotToIngredient);
    }

    public ShapelessRecipe toVanilla() {
        return new ShapelessRecipe(this.func_199560_c(), this.func_193358_e(), this.func_77571_b(), this.func_192400_c());
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.func_192400_c().size();
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.IE_SHAPELESS_SERIALIZER.get();
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int[][] map;

        public MatchLocation(int[][] map) {
            this.map = map;
        }

        @Override
        public int getListIndex(int x, int y) {
            return this.map[x][y];
        }
    }
}

