/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilTileEntity;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluorescentTubeEntity
extends Entity
implements ITeslaEntity {
    public static final float TUBE_LENGTH = 1.5f;
    public static final EntityType<FluorescentTubeEntity> TYPE = EntityType.Builder.func_220322_a(FluorescentTubeEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.75f, 1.75f).func_206830_a("immersiveengineering:fluorescent_tube");
    private static final DataParameter<Boolean> dataMarker_active;
    private static final DataParameter<Float> dataMarker_r;
    private static final DataParameter<Float> dataMarker_g;
    private static final DataParameter<Float> dataMarker_b;
    private static final DataParameter<Float> dataMarker_angleHorizontal;
    private int timer = 0;
    public boolean active = false;
    public float[] rgb = new float[4];
    boolean firstTick = true;
    public float angleHorizontal = 0.0f;

    public FluorescentTubeEntity(World world, ItemStack tube, float angleVert) {
        this(TYPE, world);
        this.field_70177_z = angleVert;
        this.rgb = FluorescentTubeItem.getRGB(tube);
    }

    public FluorescentTubeEntity(EntityType<FluorescentTubeEntity> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d motion = this.func_213322_ci();
        motion = motion.func_72441_c(0.0, -0.4, 0.0);
        this.func_213315_a(MoverType.SELF, motion);
        motion = motion.func_186678_a(0.98);
        if (this.field_70122_E) {
            motion = new Vector3d(motion.field_72450_a * 0.7, motion.field_72448_b * -0.5, motion.field_72449_c * 0.7);
        }
        if (this.firstTick && !this.field_70170_p.field_72995_K && this.rgb != null) {
            this.field_70180_af.func_187227_b(dataMarker_r, (Object)Float.valueOf(this.rgb[0]));
            this.field_70180_af.func_187227_b(dataMarker_g, (Object)Float.valueOf(this.rgb[1]));
            this.field_70180_af.func_187227_b(dataMarker_b, (Object)Float.valueOf(this.rgb[2]));
            this.field_70180_af.func_187227_b(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            this.firstTick = false;
        }
        if (this.timer > 0 && !this.field_70170_p.field_72995_K) {
            --this.timer;
            if (this.timer <= 0) {
                this.field_70180_af.func_187227_b(dataMarker_active, (Object)false);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.active = (Boolean)this.field_70180_af.func_187225_a(dataMarker_active);
            this.rgb = new float[]{((Float)this.field_70180_af.func_187225_a(dataMarker_r)).floatValue(), ((Float)this.field_70180_af.func_187225_a(dataMarker_g)).floatValue(), ((Float)this.field_70180_af.func_187225_a(dataMarker_b)).floatValue()};
            this.angleHorizontal = ((Float)this.field_70180_af.func_187225_a(dataMarker_angleHorizontal)).floatValue();
        }
        this.func_213317_d(motion);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarker_r, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarker_g, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarker_b, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(dataMarker_active, (Object)false);
        this.field_70180_af.func_187214_a(dataMarker_angleHorizontal, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(CompoundNBT nbt) {
        CompoundNBT comp = nbt.func_74775_l("nbt");
        this.rgb = new float[]{comp.func_74760_g("r"), comp.func_74760_g("g"), comp.func_74760_g("b")};
        this.angleHorizontal = nbt.func_74760_g("angleHor");
    }

    protected void func_213281_b(CompoundNBT nbt) {
        CompoundNBT comp = new CompoundNBT();
        comp.func_74776_a("r", this.rgb[0]);
        comp.func_74776_a("g", this.rgb[1]);
        comp.func_74776_a("b", this.rgb[2]);
        nbt.func_218657_a("nbt", (INBT)comp);
        nbt.func_74776_a("angleHor", this.angleHorizontal);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            ItemStack tube = new ItemStack((IItemProvider)IEItems.Misc.fluorescentTube);
            FluorescentTubeItem.setRGB(tube, this.rgb);
            ItemEntity ent = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), tube);
            this.field_70170_p.func_217376_c((Entity)ent);
            this.func_70106_y();
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    @Override
    public void onHit(TileEntity te, boolean lowPower) {
        if (te instanceof TeslaCoilTileEntity && ((TeslaCoilTileEntity)te).energyStorage.extractEnergy(1, false) > 0) {
            this.timer = 35;
            this.field_70180_af.func_187227_b(dataMarker_active, (Object)true);
        }
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d targetVec3, Hand hand) {
        if (Utils.isHammer(player.func_184586_b(hand))) {
            this.angleHorizontal += (float)(player.func_225608_bj_() ? 10 : 1);
            this.angleHorizontal %= 360.0f;
            this.field_70180_af.func_187227_b(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, targetVec3, hand);
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "fluorescent_tube");
        dataMarker_active = EntityDataManager.func_187226_a(FluorescentTubeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        dataMarker_r = EntityDataManager.func_187226_a(FluorescentTubeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        dataMarker_g = EntityDataManager.func_187226_a(FluorescentTubeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        dataMarker_b = EntityDataManager.func_187226_a(FluorescentTubeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        dataMarker_angleHorizontal = EntityDataManager.func_187226_a(FluorescentTubeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

