/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.math.MathHelper;
import codechicken.mixin.forge.TraitSide;
import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.INeighborTileChangePart;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

@MultiPartTrait(value=INeighborTileChangePart.class, side=TraitSide.SERVER)
public class TTileChangeTile
extends TileMultiPart {
    private boolean weakTileChanges = false;

    @Override
    public void copyFrom(TileMultiPart that) {
        super.copyFrom(that);
        if (that instanceof TTileChangeTile) {
            this.weakTileChanges = ((TTileChangeTile)that).weakTileChanges;
        }
    }

    @Override
    public void bindPart(TMultiPart part) {
        super.bindPart(part);
        if (part instanceof INeighborTileChangePart) {
            this.weakTileChanges |= ((INeighborTileChangePart)((Object)part)).weakTileChanges();
        }
    }

    @Override
    public void partRemoved(TMultiPart part, int p) {
        super.partRemoved(part, p);
        this.weakTileChanges = this.getPartList().stream().anyMatch(e -> e instanceof INeighborTileChangePart && ((INeighborTileChangePart)((Object)e)).weakTileChanges());
    }

    @Override
    public void onNeighborTileChange(BlockPos neighborPos) {
        super.onNeighborTileChange(neighborPos);
        BlockPos offset = neighborPos.func_177973_b((Vector3i)this.func_174877_v());
        int diff = MathHelper.absSum((BlockPos)offset);
        Direction side = MathHelper.getSide((BlockPos)offset);
        if (side == null || diff <= 0 || diff > 2) {
            return;
        }
        boolean weak = diff == 2;
        List<TMultiPart> jPartList = this.getPartList();
        int jPartListSize = jPartList.size();
        for (int i = 0; i < jPartListSize; ++i) {
            TMultiPart part = jPartList.get(i);
            if (!(part instanceof INeighborTileChangePart)) continue;
            ((INeighborTileChangePart)((Object)part)).onNeighborTileChanged(side, weak);
        }
    }
}

