/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.packet.PacketCustom;
import codechicken.mixin.api.MixinFactory;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.MultiPartGenerator;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import org.apache.commons.lang3.tuple.Pair;

public class MultiPartHelper {
    public static TileMultiPart getOrConvertTile(World world, BlockPos pos) {
        return (TileMultiPart)((Object)MultiPartHelper.getOrConvertTile2(world, pos).getLeft());
    }

    public static Pair<TileMultiPart, Boolean> getOrConvertTile2(World world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileMultiPart) {
            return Pair.of((Object)((Object)((TileMultiPart)t)), (Object)false);
        }
        Collection<TMultiPart> parts = MultiPartRegistries.convertBlock((IWorld)world, pos, world.func_180495_p(pos));
        if (!parts.isEmpty()) {
            TileMultiPart tile = MultiPartGenerator.INSTANCE.generateCompositeTile(null, parts, world.field_72995_K);
            tile.func_226984_a_(world, pos);
            parts.forEach(tile::addPart_do);
            return Pair.of((Object)((Object)tile), (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    public static TileMultiPart partRemoved(TileMultiPart tile) {
        TileMultiPart newTile = MultiPartGenerator.INSTANCE.generateCompositeTile(tile, tile.getPartList(), tile.func_145831_w().field_72995_K);
        if (tile != newTile) {
            tile.setValid(false);
            MultiPartHelper.silentAddTile(tile.func_145831_w(), tile.func_174877_v(), newTile);
            newTile.from(tile);
            newTile.notifyTileChange();
        }
        return newTile;
    }

    public static TileMultiPart addPart(World world, BlockPos pos, TMultiPart part) {
        Pair<TileMultiPart, Boolean> pair = MultiPartHelper.getOrConvertTile2(world, pos);
        TileMultiPart tile = (TileMultiPart)((Object)pair.getLeft());
        boolean converted = (Boolean)pair.getRight();
        ImmutableSet<MixinFactory.TraitKey> traits = MultiPartGenerator.INSTANCE.getTraits(part, world.field_72995_K);
        TileMultiPart newTile = tile;
        if (newTile != null) {
            ImmutableSet<MixinFactory.TraitKey> tileTraits;
            if (converted) {
                TMultiPart head = newTile.getPartList().get(0);
                head.invalidateConvertedTile();
                world.func_180501_a(pos, CBMultipartModContent.blockMultipart.func_176223_P(), 0);
                MultiPartHelper.silentAddTile(world, pos, newTile);
                PacketCustom.sendToChunk((IPacket)new SChangeBlockPacket((IBlockReader)world, pos), (World)world, (BlockPos)pos);
                head.onConverted();
                MultiPartSPH.sendAddPart(newTile, head);
            }
            if (!(tileTraits = MultiPartGenerator.INSTANCE.getTraitsForClass(((Object)((Object)tile)).getClass())).containsAll(traits)) {
                ImmutableSet newTraits = ImmutableSet.builder().addAll(tileTraits).addAll(traits).build();
                newTile = ((MultiPartGenerator.Factory)MultiPartGenerator.INSTANCE.construct((ImmutableSet<MixinFactory.TraitKey>)newTraits)).newInstance();
                newTile.setValid(false);
                MultiPartHelper.silentAddTile(world, pos, newTile);
                newTile.from(tile);
            }
        } else {
            world.func_180501_a(pos, CBMultipartModContent.blockMultipart.func_176223_P(), 0);
            newTile = ((MultiPartGenerator.Factory)MultiPartGenerator.INSTANCE.construct(traits)).newInstance();
            MultiPartHelper.silentAddTile(world, pos, newTile);
        }
        newTile.addPart_impl(part);
        return newTile;
    }

    public static void silentAddTile(World world, BlockPos pos, TileEntity tile) {
        IChunk chunk = world.func_217349_x(pos);
        if (chunk != null) {
            chunk.func_177426_a(pos, tile);
        }
    }
}

