/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.SteamJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class SteamJetEffect
extends JetEffect {
    public SteamJetEffect(int chance) {
        super(chance);
    }

    public static boolean isValidSpawnBlock(@Nonnull IBlockReader provider, @Nonnull BlockPos pos, @Nonnull BlockState source) {
        if (!WorldUtils.isAirBlock(provider, pos.func_177984_a())) {
            return false;
        }
        if (provider.func_180495_p(pos) != source) {
            return false;
        }
        return SteamJetEffect.countCubeBlocks(provider, pos, HOTBLOCK_PREDICATE, true) > 0;
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.STEAM;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return SteamJetEffect.isValidSpawnBlock(provider, pos, state) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = SteamJetEffect.countCubeBlocks(provider, pos, HOTBLOCK_PREDICATE, false);
        if (strength > 0) {
            FluidState fluidState = state.func_204520_s();
            float spawnHeight = fluidState.func_206888_e() ? (float)pos.func_177956_o() + 0.9f : (float)pos.func_177956_o() + fluidState.func_223408_f() + 0.1f;
            SteamJet effect = new SteamJet(strength, provider, (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5);
            this.addEffect(effect);
        }
    }
}

