/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.block.HidableBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RopeBlock
extends HidableBlock
implements IWaterLoggable {
    public static final EnumProperty<Rungs> RUNGS = EnumProperty.func_177709_a((String)"rungs", Rungs.class);
    public static final BooleanProperty BOTTOM = BooleanProperty.func_177716_a((String)"bottom");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final int RUNG_ITEM_COUNT = 4;
    private Item rungsItem;
    private static final VoxelShape ATTACH_TOP = Block.func_208617_a((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape ATTACH_BOTTOM = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);
    private static final VoxelShape[] SHAPE = new VoxelShape[3];
    private static final VoxelShape[] SHAPE_BOTTOM = new VoxelShape[3];

    public RopeBlock(Item rungsItem, AbstractBlock.Properties props) {
        super(props, (Supplier<Boolean>)Config.enableRope);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).func_206870_a(RUNGS, (Comparable)((Object)Rungs.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.rungsItem = rungsItem;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BOTTOM, RUNGS, WATERLOGGED});
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public Item getRungsItem() {
        return this.rungsItem;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos down = context.func_195995_a().func_177977_b();
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom(context.func_195991_k().func_180495_p(down), (IBlockReader)context.func_195991_k(), down)))).func_206870_a(RUNGS, (Comparable)((Object)Rungs.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    private boolean isBottom(BlockState state, IBlockReader world, BlockPos pos) {
        if (state.func_177230_c() == this) {
            return false;
        }
        return state.func_235714_a_((ITag)BlockTags.field_206952_E) || VoxelShapes.func_197879_c((VoxelShape)state.func_196952_d(world, pos).func_212434_a(Direction.UP), (VoxelShape)ATTACH_TOP, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return super.func_196260_a(state, world, pos) && this.isValidRope(world, pos);
    }

    private boolean isValidRope(IWorldReader world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        BlockState state = world.func_180495_p(up);
        if (state.func_177230_c() == this) {
            return true;
        }
        return !state.func_235714_a_((ITag)BlockTags.field_206952_E) && !VoxelShapes.func_197879_c((VoxelShape)state.func_196952_d((IBlockReader)world, pos).func_212434_a(Direction.DOWN), (VoxelShape)ATTACH_BOTTOM, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (!this.isValidRope((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (facing == Direction.DOWN) {
            BlockPos down = pos.func_177977_b();
            return (BlockState)state.func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom(world.func_180495_p(down), (IBlockReader)world, down)));
        }
        return state;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hit.func_216354_b().func_176740_k().func_200128_b()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (Block.func_149634_a((Item)stack.func_77973_b()) != this) {
            return ActionResultType.PASS;
        }
        BlockPos next = pos.func_177977_b();
        while (world.func_180495_p(next).func_177230_c() == this) {
            next = next.func_177977_b();
        }
        if (this.func_196260_a(state, (IWorldReader)world, next)) {
            ((BlockItem)stack.func_77973_b()).func_195942_a(new BlockItemUseContext(player, hand, stack, new BlockRayTraceResult(Vector3d.func_237492_c_((Vector3i)next), Direction.UP, next, false)));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos next = pos.func_177977_b();
        int count = 0;
        int rungs = 0;
        BlockState below = world.func_180495_p(next);
        while (below.func_177230_c() == this) {
            ++count;
            if (below.func_177229_b(RUNGS) != Rungs.NONE) {
                ++rungs;
            }
            next = next.func_177977_b();
            below = world.func_180495_p(next);
        }
        for (int i = 0; i < count; ++i) {
            next = next.func_177984_a();
            world.func_175655_b(next, false);
        }
        ItemStack drops = new ItemStack((IItemProvider)this, count);
        RopeBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drops);
        if (rungs > 0) {
            RopeBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this.rungsItem, rungs * 4));
        }
        super.func_176208_a(world, pos, state, player);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((Boolean)state.func_177229_b((Property)BOTTOM) != false ? SHAPE_BOTTOM : SHAPE)[((Rungs)((Object)state.func_177229_b(RUNGS))).ordinal()];
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(RUNGS) != Rungs.NONE ? state.func_196954_c(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    static {
        VoxelShape rope_core = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape rope_core_bottom = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)6.5, (double)4.0, (double)6.5, (double)9.5, (double)7.0, (double)9.5));
        VoxelShape rope_rungs_x = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)5.0, (double)7.0, (double)15.0, (double)7.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)9.0, (double)7.0, (double)15.0, (double)11.0, (double)9.0), Block.func_208617_a((double)1.0, (double)13.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0)});
        VoxelShape rope_rungs_z = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)5.0, (double)1.0, (double)9.0, (double)7.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)7.0, (double)9.0, (double)1.0, (double)9.0, (double)11.0, (double)15.0), Block.func_208617_a((double)7.0, (double)13.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0)});
        RopeBlock.SHAPE[Rungs.NONE.ordinal()] = rope_core;
        RopeBlock.SHAPE_BOTTOM[Rungs.NONE.ordinal()] = rope_core_bottom;
        RopeBlock.SHAPE[Rungs.X.ordinal()] = VoxelShapes.func_216384_a((VoxelShape)rope_core, (VoxelShape[])new VoxelShape[]{rope_rungs_x, Block.func_208617_a((double)1.0, (double)1.0, (double)7.0, (double)15.0, (double)3.0, (double)9.0)});
        RopeBlock.SHAPE_BOTTOM[Rungs.X.ordinal()] = VoxelShapes.func_197872_a((VoxelShape)rope_core_bottom, (VoxelShape)rope_rungs_x);
        RopeBlock.SHAPE[Rungs.Z.ordinal()] = VoxelShapes.func_216384_a((VoxelShape)rope_core, (VoxelShape[])new VoxelShape[]{rope_rungs_z, Block.func_208617_a((double)7.0, (double)1.0, (double)1.0, (double)9.0, (double)3.0, (double)15.0)});
        RopeBlock.SHAPE_BOTTOM[Rungs.Z.ordinal()] = VoxelShapes.func_197872_a((VoxelShape)rope_core_bottom, (VoxelShape)rope_rungs_z);
    }

    public static enum Rungs implements IStringSerializable
    {
        NONE,
        X,
        Z;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static Rungs fromAxis(Direction.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }
    }
}

