/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.mantle.block.RetexturedBlock;

public class ShelfBlock
extends InventoryBlock
implements IHidable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final ImmutableMap<Direction, VoxelShape> BOUNDS;

    public ShelfBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ShelfTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        RetexturedBlock.updateTextureBlock((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableBookshelf.get();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, items);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing.func_176734_d() == trace.func_216354_b()) {
            return ActionResultType.PASS;
        }
        if (player.func_213453_ef()) {
            return world.field_72995_K || this.openGui(player, world, pos) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        Vector3d hitWorld = trace.func_216347_e();
        Vector3d click = new Vector3d(hitWorld.field_72450_a - (double)pos.func_177958_n(), hitWorld.field_72448_b - (double)pos.func_177956_o(), hitWorld.field_72449_c - (double)pos.func_177952_p());
        if (!ShelfBlock.isBookClicked(facing, click)) {
            return world.field_72995_K || this.openGui(player, world, pos) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShelfTileEntity) {
            if (((ShelfTileEntity)te).interact(player, hand, click)) {
                return ActionResultType.SUCCESS;
            }
            if (hand != Hand.OFF_HAND && !player.func_184592_cb().func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.CONSUME;
    }

    private static boolean isBookClicked(Direction facing, Vector3d click) {
        if (click.field_72448_b < 0.0625 || click.field_72448_b > 0.9375) {
            return false;
        }
        if (click.field_72448_b > 0.4375 && click.field_72448_b < 0.5625) {
            return false;
        }
        int offX = facing.func_82601_c();
        int offZ = facing.func_82599_e();
        double x1 = offX == -1 ? 0.625 : 0.0;
        double z1 = offZ == -1 ? 0.625 : 0.0;
        double x2 = offX == 1 ? 0.375 : 1.0;
        double z2 = offZ == 1 ? 0.375 : 1.0;
        return !(click.field_72450_a < x1 || click.field_72450_a > x2 || click.field_72449_c < z1 || click.field_72449_c > z2);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)BOUNDS.get((Object)state.func_177229_b((Property)FACING));
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShelfTileEntity) {
            return ((ShelfTileEntity)te).getComparatorPower();
        }
        return 0;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return RetexturedBlock.getPickBlock((IBlockReader)world, (BlockPos)pos, (BlockState)state);
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        if (!((Boolean)Config.bookshelvesBoostEnchanting.get()).booleanValue()) {
            return 0.0f;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShelfTileEntity) {
            return ((ShelfTileEntity)te).getEnchantPower();
        }
        return 0.0f;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Direction side : Direction.Plane.HORIZONTAL) {
            int offX = side.func_82601_c();
            int offZ = side.func_82599_e();
            double x1 = offX == -1 ? 0.5 : 0.0;
            double z1 = offZ == -1 ? 0.5 : 0.0;
            double x2 = offX == 1 ? 0.5 : 1.0;
            double z2 = offZ == 1 ? 0.5 : 1.0;
            Vector3d min = new Vector3d(-0.5, 0.0, -0.4375).func_178785_b(-1.5707964f * (float)side.func_176736_b());
            Vector3d max = new Vector3d(0.5, 1.0, 0.0).func_178785_b(-1.5707964f * (float)side.func_176736_b());
            builder.put((Object)side, (Object)VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197873_a((double)x1, (double)0.0, (double)z1, (double)x2, (double)1.0, (double)z2), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)(0.5 + min.field_72450_a), (double)0.0625, (double)(0.5 + min.field_72449_c), (double)(0.5 + max.field_72450_a), (double)0.4375, (double)(0.5 + max.field_72449_c)), (VoxelShape)VoxelShapes.func_197873_a((double)(0.5 + min.field_72450_a), (double)0.5625, (double)(0.5 + min.field_72449_c), (double)(0.5 + max.field_72450_a), (double)0.9375, (double)(0.5 + max.field_72449_c))), (IBooleanFunction)IBooleanFunction.field_223234_e_));
        }
        BOUNDS = builder.build();
    }
}

