/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.datagen;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.type.FlowerType;
import knightminer.inspirations.building.block.type.MulchType;
import knightminer.inspirations.building.block.type.PathType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.common.datagen.IInspirationsRecipeBuilder;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipeBuilder;

public class BuildingRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IInspirationsRecipeBuilder {
    private Consumer<IFinishedRecipe> consumer;

    public BuildingRecipeProvider(DataGenerator gen) {
        super(gen);
    }

    public String func_200397_b() {
        return "Inspirations Recipes - Building";
    }

    public Consumer<IFinishedRecipe> getConsumer() {
        return this.consumer;
    }

    @Override
    public ICondition baseCondition() {
        return ConfigEnabledCondition.MODULE_BUILDING;
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
        Consumer glassDoorCondition = this.withCondition(new ICondition[]{ConfigEnabledCondition.GLASS_DOOR});
        ShapedRecipeBuilder.func_200470_a((IItemProvider)InspirationsBuilding.glassDoor).func_200465_a("has_glass", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221792_df)).func_200462_a(Character.valueOf('G'), (IItemProvider)Items.field_221792_df).func_200472_a("GG").func_200472_a("GG").func_200472_a("GG").func_200467_a(glassDoorCondition, this.prefix((IItemProvider)InspirationsBuilding.glassDoor, "building/"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)InspirationsBuilding.glassTrapdoor, (int)2).func_200465_a("has_glass", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221792_df)).func_200462_a(Character.valueOf('G'), (IItemProvider)Items.field_221792_df).func_200472_a("GGG").func_200472_a("GGG").func_200467_a(glassDoorCondition, this.prefix((IItemProvider)InspirationsBuilding.glassTrapdoor, "building/"));
        Consumer ropeCondition = this.withCondition(new ICondition[]{ConfigEnabledCondition.ROPE});
        ShapedRecipeBuilder.func_200468_a((IItemProvider)InspirationsBuilding.rope, (int)3).func_200465_a("has_string", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)Tags.Items.STRING)).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151007_F).func_200472_a("SS").func_200472_a("SS").func_200472_a("SS").func_200467_a(ropeCondition, this.prefix((IItemProvider)InspirationsBuilding.rope, "building/"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)InspirationsBuilding.vine, (int)3).func_200465_a("has_vines", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221796_dh)).func_200462_a(Character.valueOf('V'), (IItemProvider)Items.field_221796_dh).func_200472_a("V").func_200472_a("V").func_200472_a("V").func_200467_a(ropeCondition, this.prefix((IItemProvider)InspirationsBuilding.vine, "building/"));
        Consumer pathCondition = this.withCondition(new ICondition[]{ConfigEnabledCondition.PATH});
        this.addPath(pathCondition, PathType.BRICK, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221647_bL}), (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221647_bL));
        this.addPath(pathCondition, PathType.ROCK, Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE), (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)Tags.Items.COBBLESTONE));
        this.addPath(pathCondition, PathType.ROUND, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b}), (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221574_b));
        this.addPath(pathCondition, PathType.TILE, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221723_cX}), (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_221723_cX));
        Consumer mulchCondition = this.withCondition(new ICondition[]{ConfigEnabledCondition.MULCH});
        IItemProvider plainMulch = (IItemProvider)InspirationsBuilding.mulch.get((Enum)MulchType.PLAIN);
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199805_a((ITag)ItemTags.field_199905_b), (IItemProvider)plainMulch).func_218643_a("hasPlanks", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)ItemTags.field_199905_b)).func_218647_a(mulchCondition, this.resource("building/mulch/" + MulchType.PLAIN.func_176610_l()));
        InspirationsBuilding.mulch.forEach((type, mulch) -> {
            DyeColor dye = type.getDye();
            if (dye != null) {
                ShapelessRecipeBuilder.func_200486_a((IItemProvider)mulch).func_200483_a("has_mulch", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)plainMulch)).func_200487_b(plainMulch).func_203221_a((ITag)dye.getTag()).func_200485_a(mulchCondition, this.resource("building/mulch/" + type.func_176610_l()));
            }
        });
        Consumer bookConditions = this.withCondition(new ICondition[]{ConfigEnabledCondition.COLORED_BOOKS});
        String bookGroup = this.resourceName("colored_book");
        InspirationsBuilding.coloredBooks.forEach((color, book) -> ShapelessRecipeBuilder.func_200486_a((IItemProvider)book).func_200483_a("has_bookshelf", (ICriterionInstance)BuildingRecipeProvider.func_200409_a(InspirationsTags.Items.BOOKSHELVES)).func_200490_a(bookGroup).func_200487_b((IItemProvider)Items.field_151122_aG).func_203221_a((ITag)color.getTag()).func_200485_a(bookConditions, this.resource("building/books/" + color.func_176610_l())));
        Consumer flowerConditions = this.withCondition(new ICondition[]{ConfigEnabledCondition.FLOWERS});
        InspirationsBuilding.flower.forEach((type, flower) -> {
            Item dye = type.getDye();
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)dye).func_200483_a("has_flower", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)flower)).func_200490_a(Objects.requireNonNull(dye).toString()).func_200487_b((IItemProvider)flower).func_200485_a(flowerConditions, this.resource("building/flower/" + Objects.requireNonNull(dye.getRegistryName()).func_110623_a()));
        });
        Consumer cyanFlowerConditions = this.withCondition(new ICondition[]{ConfigEnabledCondition.FLOWERS, this.not(ConfigEnabledCondition.CAULDRON_DYEING)});
        IItemProvider rose = (IItemProvider)InspirationsBuilding.flower.get((Enum)FlowerType.ROSE);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)InspirationsBuilding.flower.get((Enum)FlowerType.CYAN))).func_200483_a("has_dye", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)Tags.Items.DYES_CYAN)).func_200483_a("has_flower", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)rose)).func_203221_a((ITag)Tags.Items.DYES_CYAN).func_200487_b(rose).func_200485_a(cyanFlowerConditions, this.resource("building/flower/cyan_flower"));
        Consumer bookshelfConditions = this.withCondition(new ICondition[]{ConfigEnabledCondition.BOOKSHELF});
        String shelfGroup = this.resourceName("bookshelf");
        InspirationsBuilding.shelf.forEach((type, shelf) -> {
            String[] variants;
            for (String variant : variants = BuildingRecipeProvider.getShelfVariants(type)) {
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200468_a((IItemProvider)shelf, (int)2).func_200473_b(shelfGroup).func_200465_a("has_slabs", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)ItemTags.field_202899_i)).func_200465_a("has_book", (ICriterionInstance)BuildingRecipeProvider.func_200403_a((IItemProvider)Items.field_151122_aG)).func_200469_a(Character.valueOf('S'), (ITag)ItemTags.field_202899_i).func_200472_a("SSS").func_200472_a(variant).func_200472_a("SSS");
                switch (type) {
                    case ANCIENT: {
                        builder.func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF);
                        break;
                    }
                    case TOMES: {
                        builder.func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG);
                        break;
                    }
                    case RAINBOW: {
                        builder.func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DYES_RED).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.DYES_GREEN).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.DYES_BLUE);
                    }
                }
                String suffix = variants.length > 1 ? "_" + variant.toLowerCase(Locale.US) : "";
                ShapedRetexturedRecipeBuilder.fromShaped((ShapedRecipeBuilder)builder).setSource((ITag)ItemTags.field_202899_i).setMatchAll().build(bookshelfConditions, this.resource("building/bookshelves/" + type.func_176610_l() + suffix));
            }
        });
        Consumer bushConditions = this.withCondition(new ICondition[]{ConfigEnabledCondition.ENLIGHTENED_BUSH});
        String bushGroup = this.resourceName("enlightened_bush");
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200470_a((IItemProvider)bush).func_200473_b(bushGroup).func_200465_a("has_leaves", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)ItemTags.field_206963_E)).func_200465_a("has_glowstone", (ICriterionInstance)BuildingRecipeProvider.func_200409_a((ITag)Tags.Items.DUSTS_GLOWSTONE)).func_200469_a(Character.valueOf('L'), (ITag)ItemTags.field_206963_E).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.DUSTS_GLOWSTONE);
            DyeColor dye = type.getDye();
            if (dye != null) {
                builder = builder.func_200469_a(Character.valueOf('D'), (ITag)dye.getTag()).func_200472_a(" D ");
            }
            builder.func_200472_a("GLG");
            ShapedRetexturedRecipeBuilder.fromShaped((ShapedRecipeBuilder)builder).setSource((ITag)ItemTags.field_206963_E).build(bushConditions, this.resource("building/enlightened_bush/" + type.func_176610_l()));
        });
    }

    private void addPath(Consumer<IFinishedRecipe> consumer, PathType type, Ingredient ingredient, ICriterionInstance criteria) {
        IItemProvider path = (IItemProvider)InspirationsBuilding.path.get((Enum)type);
        if (type != PathType.ROUND) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)path, (int)6).func_200465_a("has_item", criteria).func_200471_a(Character.valueOf('C'), ingredient).func_200472_a("CC").func_200467_a(consumer, this.resource("building/path/" + type.func_176610_l() + "_crafting"));
        }
        SingleItemRecipeBuilder.func_218644_a((Ingredient)ingredient, (IItemProvider)path, (int)6).func_218643_a("has_stone", criteria).func_218647_a(consumer, this.resource("building/path/" + type.func_176610_l() + "_cutting"));
    }

    private static String[] getShelfVariants(ShelfType type) {
        switch (type) {
            default: {
                return new String[]{" S "};
            }
            case ANCIENT: {
                return new String[]{"PPP"};
            }
            case TOMES: {
                return new String[]{" B "};
            }
            case RAINBOW: 
        }
        return new String[]{"RGB", "RBG", "GRB"};
    }
}

