/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;

public class CauldronStateUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    @Nullable
    private final ICauldronContents contents;
    private final int levelOffset;

    public CauldronStateUpdatePacket(BlockPos pos, @Nullable ICauldronContents contents, int levelOffset) {
        this.pos = pos;
        this.contents = contents;
        this.levelOffset = levelOffset;
    }

    public CauldronStateUpdatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.contents = buffer.readBoolean() ? CauldronContentTypes.read(buffer) : null;
        this.levelOffset = buffer.readByte();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        if (this.contents != null) {
            buffer.writeBoolean(true);
            this.contents.write(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeByte(this.levelOffset);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(CauldronStateUpdatePacket packet) {
            TileEntityHelper.getTile(CauldronTileEntity.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)packet.pos, (boolean)true).ifPresent(te -> {
                if (te.updateStateAndData(packet.contents, packet.levelOffset)) {
                    Util.notifyClientUpdate((TileEntity)te);
                }
            });
        }
    }
}

