/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigurableResourcePack
extends ResourcePack
implements IPackFinder {
    private final Class<?> resourceLoader;
    private final String packId;
    private final String displayName;
    private final String pathPrefix;
    private final Set<String> namespaces;
    private final Map<String, Replacement> replacements = new HashMap<String, Replacement>();

    public ConfigurableResourcePack(Class<?> resourceLoader, ResourceLocation packId, String displayName, Set<String> namespaces) {
        this(resourceLoader, packId.toString(), String.format("/%s/%s/%s/", ResourcePackType.CLIENT_RESOURCES.func_198956_a(), packId.func_110624_b(), packId.func_110623_a()), displayName, namespaces);
    }

    private ConfigurableResourcePack(Class<?> resourceLoader, String packId, String pathPrefix, String displayName, Set<String> namespaces) {
        super(new File(pathPrefix));
        this.resourceLoader = resourceLoader;
        this.packId = packId;
        this.displayName = displayName;
        this.pathPrefix = pathPrefix;
        this.namespaces = namespaces;
    }

    public String func_195762_a() {
        return this.displayName;
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return type == ResourcePackType.CLIENT_RESOURCES ? this.namespaces : Collections.emptySet();
    }

    private InputStream getPackResource(String name) {
        return this.resourceLoader.getResourceAsStream(this.pathPrefix + name);
    }

    protected InputStream func_195766_a(String name) throws IOException {
        if (name.equals("pack.mcmeta") || name.equals("pack.png")) {
            return this.getPackResource(name);
        }
        Replacement replacement = this.replacements.get(name);
        if (replacement != null && replacement.isEnabled()) {
            return this.getPackResource(replacement.getName());
        }
        throw new ResourcePackFileNotFoundException(this.field_195771_a, name);
    }

    protected boolean func_195768_c(String name) {
        Replacement replacement = this.replacements.get(name);
        return replacement != null && replacement.isEnabled();
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String domain, String path, int maxDepth, Predicate<String> filter) {
        return Collections.emptyList();
    }

    public void close() {
    }

    public void func_230230_a_(Consumer<ResourcePackInfo> consumer, ResourcePackInfo.IFactory factory) {
        consumer.accept(ResourcePackInfo.func_195793_a((String)this.packId, (boolean)true, () -> this, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, name -> new TranslationTextComponent("pack.nameAndSource", new Object[]{name, "inspirations"})));
    }

    public void addReplacement(BooleanSupplier condition, String originalPath, String resource) {
        if (this.replacements.containsKey(originalPath)) {
            throw new IllegalArgumentException("Duplicate replacement '" + originalPath + "' for configurable pack " + this.packId);
        }
        this.replacements.put(originalPath, new Replacement(condition, resource));
    }

    private static String makePath(ResourceLocation id, String folder, String extension) {
        return String.format("%s/%s/%s/%s.%s", ResourcePackType.CLIENT_RESOURCES.func_198956_a(), id.func_110624_b(), folder, id.func_110623_a(), extension);
    }

    public void addBlockstateReplacement(BooleanSupplier condition, Block block, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Objects.requireNonNull(block.getRegistryName()), "blockstates", "json"), "blockstates/" + resource + ".json");
    }

    public void addItemModelReplacement(BooleanSupplier condition, IItemProvider item, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Objects.requireNonNull(item.func_199767_j().getRegistryName()), "models/item", "json"), "item_models/" + resource + ".json");
    }

    private static class Replacement {
        private final BooleanSupplier condition;
        private final String name;

        public Replacement(BooleanSupplier condition, String name) {
            this.name = name;
            this.condition = condition;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.condition.getAsBoolean();
        }
    }
}

