/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.inspirations.recipes.RecipesClientEvents;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class CauldronModel
implements IModelGeometry<CauldronModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> retextured;
    private final float liquidOffset;

    protected CauldronModel(SimpleBlockModel model, Set<String> retextured, float liquidOffset) {
        this.model = model;
        this.retextured = retextured;
        this.liquidOffset = liquidOffset;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Collection textures = this.model.getTextures(owner, modelGetter, missingTextureErrors);
        if (owner.isTexturePresent("frost")) {
            textures.add(owner.resolveTexture("frost"));
        } else {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)"frost", (Object)owner.getModelName()));
        }
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        Set retextured = this.retextured.isEmpty() ? Collections.emptySet() : RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.retextured);
        ArrayList<BlockPart> warmElements = new ArrayList<BlockPart>();
        ArrayList<BlockPart> frostElements = new ArrayList<BlockPart>();
        ArrayList<BlockPart> liquidElements = new ArrayList();
        for (BlockPart part : this.model.getElements()) {
            boolean updated = false;
            EnumMap<Direction, BlockPartFace> warmFaces = new EnumMap<Direction, BlockPartFace>(Direction.class);
            EnumMap<Direction, BlockPartFace> frostFaces = new EnumMap<Direction, BlockPartFace>(Direction.class);
            EnumMap<Direction, BlockPartFace> liquidFaces = new EnumMap<Direction, BlockPartFace>(Direction.class);
            for (Map.Entry entry : part.field_178240_c.entrySet()) {
                BlockPartFace face = (BlockPartFace)entry.getValue();
                if (retextured.contains(face.field_178242_d.substring(1))) {
                    liquidFaces.put((Direction)entry.getKey(), new BlockPartFace(face.field_178244_b, 1, face.field_178242_d, face.field_178243_e));
                    continue;
                }
                warmFaces.put((Direction)entry.getKey(), face);
                frostFaces.put((Direction)entry.getKey(), new BlockPartFace(face.field_178244_b, -1, "frost", face.field_178243_e));
            }
            BlockPart newPart = part;
            if (!liquidFaces.isEmpty()) {
                newPart = new BlockPart(part.field_178241_a, part.field_178239_b, warmFaces, part.field_178237_d, part.field_178238_e);
                Vector3f newTo = part.field_178239_b;
                if (this.liquidOffset != 0.0f) {
                    newTo = part.field_178239_b.func_229195_e_();
                    newTo.func_195904_b(0.0f, this.liquidOffset, 0.0f);
                }
                liquidElements.add(new BlockPart(part.field_178241_a, newTo, liquidFaces, part.field_178237_d, part.field_178238_e));
            }
            warmElements.add(newPart);
            frostElements.add(newPart);
            if (frostFaces.isEmpty()) continue;
            frostElements.add(new BlockPart(part.field_178241_a, part.field_178239_b, frostFaces, part.field_178237_d, part.field_178238_e));
        }
        ArrayList<BlockPart> firstBake = warmElements;
        if (liquidElements.isEmpty()) {
            liquidElements = Collections.emptyList();
        } else {
            firstBake = new ArrayList(warmElements);
            firstBake.addAll(liquidElements);
        }
        IBakedModel baked = SimpleBlockModel.bakeModel((IModelConfiguration)owner, firstBake, (IModelTransform)modelTransform, (ItemOverrideList)overrides, spriteGetter, (ResourceLocation)modelLocation);
        if (retextured.isEmpty()) {
            IBakedModel frosted = SimpleBlockModel.bakeModel((IModelConfiguration)owner, frostElements, (IModelTransform)modelTransform, (ItemOverrideList)overrides, spriteGetter, (ResourceLocation)modelLocation);
            return new FrostedBakedModel(baked, frosted);
        }
        return new TexturedBakedModel(baked, owner, warmElements, frostElements, liquidElements, modelTransform, retextured);
    }

    private static class Loader
    implements IModelLoader<CauldronModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public CauldronModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            Set retextured = json.has("retextured") ? RetexturedModel.Loader.getRetextured((JsonObject)json) : Collections.emptySet();
            float offset = JSONUtils.func_151221_a((JsonObject)json, (String)"liquid_offset", (float)0.0f);
            return new CauldronModel(model, retextured, offset);
        }
    }

    private static class TextureOffsetPair {
        private final ResourceLocation location;
        private final int offset;

        private TextureOffsetPair(ResourceLocation location, int offset) {
            this.location = location;
            this.offset = offset;
        }

        public int hashCode() {
            return this.location.hashCode() + 31 * this.offset;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextureOffsetPair)) {
                return false;
            }
            TextureOffsetPair pair = (TextureOffsetPair)other;
            return this.offset == pair.offset && this.location.equals((Object)pair.location);
        }
    }

    private static class FrostedBakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final IBakedModel frosted;

        private FrostedBakedModel(IBakedModel originalModel, IBakedModel frosted) {
            super(originalModel);
            this.frosted = frosted;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            return (data.getData(CauldronTileEntity.FROSTED) == Boolean.TRUE ? this.frosted : this.originalModel).getQuads(state, direction, random, data);
        }
    }

    private static class TexturedBakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final Map<TextureOffsetPair, IBakedModel> warmCache = new HashMap<TextureOffsetPair, IBakedModel>();
        private final Map<TextureOffsetPair, IBakedModel> frostedCache = new HashMap<TextureOffsetPair, IBakedModel>();
        private final IModelConfiguration owner;
        private final IModelTransform transform;
        private final Set<String> retextured;
        private final List<BlockPart> liquidElements;
        private final Function<TextureOffsetPair, IBakedModel> warmBakery;
        private final Function<TextureOffsetPair, IBakedModel> frostedBakery;

        protected TexturedBakedModel(IBakedModel originalModel, IModelConfiguration owner, List<BlockPart> warmElements, List<BlockPart> frostElements, List<BlockPart> liquidElements, IModelTransform transform, Set<String> fluidNames) {
            super(originalModel);
            this.owner = owner;
            this.transform = transform;
            this.retextured = fluidNames;
            this.liquidElements = liquidElements;
            this.warmBakery = name -> this.getFluidModel((TextureOffsetPair)name, warmElements);
            this.frostedBakery = name -> this.getFluidModel((TextureOffsetPair)name, frostElements);
        }

        private IBakedModel getFluidModel(TextureOffsetPair pair, List<BlockPart> baseElements) {
            ArrayList<BlockPart> elements = new ArrayList<BlockPart>(baseElements);
            if (pair.offset == 0) {
                elements.addAll(this.liquidElements);
            } else {
                float offset = MathHelper.func_76131_a((float)pair.offset, (float)-2.95f, (float)3.0f);
                this.liquidElements.stream().map(part -> {
                    Vector3f newTo = part.field_178239_b.func_229195_e_();
                    newTo.func_195904_b(0.0f, offset, 0.0f);
                    return new BlockPart(part.field_178241_a, newTo, part.field_178240_c, part.field_178237_d, part.field_178238_e);
                }).forEach(elements::add);
            }
            return SimpleBlockModel.bakeDynamic((IModelConfiguration)new RetexturedModel.RetexturedConfiguration(this.owner, this.retextured, pair.location), elements, (IModelTransform)this.transform);
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            if (data == EmptyModelData.INSTANCE) {
                return this.originalModel.getQuads(state, direction, random, data);
            }
            ResourceLocation texture = (ResourceLocation)data.getData(CauldronTileEntity.TEXTURE);
            texture = texture == null ? MissingTextureSprite.func_195675_b() : RecipesClientEvents.cauldronTextures.getTexture(texture);
            Integer offset = (Integer)data.getData(CauldronTileEntity.OFFSET);
            TextureOffsetPair pair = new TextureOffsetPair(texture, offset == null ? 0 : offset);
            IBakedModel baked = data.getData(CauldronTileEntity.FROSTED) == Boolean.TRUE ? this.frostedCache.computeIfAbsent(pair, this.frostedBakery) : this.warmCache.computeIfAbsent(pair, this.warmBakery);
            return baked.getQuads(state, direction, random, data);
        }
    }
}

