/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class ShelfModel
implements IModelGeometry<ShelfModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> retextured;
    private final List<List<BlockPart>> books;
    private final List<ModelItem> items;

    protected ShelfModel(SimpleBlockModel model, Set<String> retextured, List<List<BlockPart>> books, List<ModelItem> items) {
        this.model = model;
        this.retextured = retextured;
        this.books = books;
        this.items = items;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.model.fetchParent(owner, modelGetter);
        ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
        this.books.forEach(elements::addAll);
        return SimpleBlockModel.getTextures((IModelConfiguration)owner, (List)elements, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transforms, ItemOverrideList overrides, ResourceLocation location) {
        Shelf model = new Shelf(owner, this.model, transforms, this.books);
        IBakedModel baked = model.bake(spriteGetter, location);
        return new BakedModel(baked, model, RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.retextured), this.items);
    }

    private static class BookshelfCacheKey {
        @Nullable
        protected ResourceLocation texture;
        protected int books;

        BookshelfCacheKey(@Nullable ResourceLocation texture, int books) {
            this.texture = texture;
            this.books = books;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BookshelfCacheKey that = (BookshelfCacheKey)o;
            return this.books == that.books && Objects.equals(this.texture, that.texture);
        }

        public int hashCode() {
            return (this.texture == null ? 0 : 31 * this.texture.hashCode()) + this.books;
        }
    }

    private static class RetexturedOverride
    extends ItemOverrideList {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (stack.func_190926_b() || !stack.func_77942_o()) {
                return originalModel;
            }
            Block block = RetexturedBlockItem.getTexture((ItemStack)stack);
            if (block == Blocks.field_150350_a) {
                return originalModel;
            }
            return ((BakedModel)originalModel).getTexturedShelf(block).getBaked();
        }
    }

    public static class BakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final Map<ResourceLocation, Shelf> texturedCache = new HashMap<ResourceLocation, Shelf>();
        private final Cache<BookshelfCacheKey, IBakedModel> bookshelfCache = CacheBuilder.newBuilder().maximumSize(30L).build();
        private final Shelf model;
        private final Set<String> retextured;
        private final List<ModelItem> items;

        protected BakedModel(IBakedModel baked, Shelf model, Set<String> retextured, List<ModelItem> items) {
            super(baked);
            this.model = model;
            this.retextured = retextured;
            this.items = items;
        }

        private Shelf getTexturedShelf(@Nullable ResourceLocation texture) {
            if (texture == null) {
                return this.model;
            }
            return this.texturedCache.computeIfAbsent(texture, location -> this.model.withTexture(this.retextured, (ResourceLocation)location));
        }

        private Shelf getTexturedShelf(Block texture) {
            return this.getTexturedShelf(ModelHelper.getParticleTexture((Block)texture));
        }

        public TextureAtlasSprite getParticleTexture(IModelData data) {
            Block block;
            if (this.retextured.contains("particle") && (block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY)) != null && block != Blocks.field_150350_a) {
                return this.getTexturedShelf(block).getBaked().getParticleTexture(data);
            }
            return this.originalModel.getParticleTexture(data);
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            IBakedModel finalModel;
            Integer books;
            if (data == EmptyModelData.INSTANCE) {
                return this.originalModel.getQuads(state, direction, random, data);
            }
            Block block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY);
            ResourceLocation texture = null;
            if (block != null && block != Blocks.field_150350_a) {
                texture = ModelHelper.getParticleTexture((Block)block);
            }
            if ((books = (Integer)data.getData(ShelfTileEntity.BOOKS)) == null) {
                books = 0;
            }
            try {
                BookshelfCacheKey key = new BookshelfCacheKey(texture, books);
                finalModel = (IBakedModel)this.bookshelfCache.get((Object)key, () -> this.getTexturedShelf(key.texture).bakeWithBooks(key.books));
            }
            catch (ExecutionException e) {
                Inspirations.log.error((Object)e);
                finalModel = this.originalModel;
            }
            return finalModel.getQuads(state, direction, random, data);
        }

        public ItemOverrideList func_188617_f() {
            return RetexturedOverride.INSTANCE;
        }

        public List<ModelItem> getItems() {
            return this.items;
        }
    }

    private static class Shelf {
        private final IModelConfiguration owner;
        private final SimpleBlockModel model;
        private final IModelTransform transform;
        private final List<List<BlockPart>> books;
        private IBakedModel baked;

        private Shelf(IModelConfiguration owner, SimpleBlockModel model, IModelTransform transform, List<List<BlockPart>> books) {
            this.owner = owner;
            this.model = model;
            this.transform = transform;
            this.books = books;
        }

        public IBakedModel bake(Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
            ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
            this.books.forEach(elements::addAll);
            this.baked = SimpleBlockModel.bakeModel((IModelConfiguration)this.owner, (List)elements, (IModelTransform)this.transform, (ItemOverrideList)ItemOverrideList.field_188022_a, spriteGetter, (ResourceLocation)location);
            return this.baked;
        }

        public IBakedModel getBaked() {
            if (this.baked == null) {
                ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
                this.books.forEach(elements::addAll);
                this.baked = SimpleBlockModel.bakeDynamic((IModelConfiguration)this.owner, (List)elements, (IModelTransform)this.transform);
            }
            return this.baked;
        }

        public Shelf withTexture(Set<String> retextured, ResourceLocation texture) {
            return new Shelf((IModelConfiguration)new RetexturedModel.RetexturedConfiguration(this.owner, retextured, texture), this.model, this.transform, this.books);
        }

        public IBakedModel bakeWithBooks(int modelBooks) {
            ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
            for (int i = 0; i < this.books.size(); ++i) {
                int flag = 1 << i;
                if ((modelBooks & flag) != flag) continue;
                elements.addAll((Collection)this.books.get(i));
            }
            return SimpleBlockModel.bakeDynamic((IModelConfiguration)this.owner, (List)elements, (IModelTransform)this.transform);
        }
    }

    private static class Loader
    implements IModelLoader<ShelfModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ShelfModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            Set retextured = RetexturedModel.Loader.getRetextured((JsonObject)json);
            JsonArray bookArray = JSONUtils.func_151214_t((JsonObject)json, (String)"books");
            if (bookArray.size() == 0) {
                throw new JsonSyntaxException("Must have at least one book element");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < bookArray.size(); ++i) {
                builder.add((Object)SimpleBlockModel.getModelElements((JsonDeserializationContext)context, (JsonElement)bookArray.get(i), (String)("books[" + i + "]")));
            }
            List items = ModelItem.listFromJson((JsonObject)json, (String)"items");
            return new ShelfModel(model, retextured, (List<List<BlockPart>>)builder.build(), items);
        }
    }
}

