/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fml.ModList;

public class ModItemList
extends CompoundIngredient {
    public static final Factory SERIALIZER = new Factory();

    protected ModItemList(List<Ingredient> children) {
        super(children);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return new Factory();
    }

    public static class Factory
    implements IIngredientSerializer<ModItemList> {
        public ModItemList parse(JsonObject json) {
            LinkedList<Ingredient> ingredientList = new LinkedList<Ingredient>();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (JsonElement ingredient : ingredients) {
                JsonObject object = ingredient.getAsJsonObject();
                if (JSONUtils.func_151204_g((JsonObject)object, (String)"modid")) {
                    String mod = JSONUtils.func_151200_h((JsonObject)object, (String)"modid");
                    if (!ModList.get().isLoaded(mod)) continue;
                }
                if (JSONUtils.func_151204_g((JsonObject)object, (String)"ingredient")) {
                    ingredientList.add(CraftingHelper.getIngredient((JsonElement)object.get("ingredient")));
                    continue;
                }
                ingredientList.add(CraftingHelper.getIngredient((JsonElement)object));
            }
            return new ModItemList(ingredientList);
        }

        public void write(PacketBuffer buffer, ModItemList ingredient) {
            buffer.func_150787_b(ingredient.getChildren().size());
            ingredient.getChildren().forEach(child -> child.func_199564_a(buffer));
        }

        public ModItemList parse(PacketBuffer buffer) {
            return new ModItemList(Stream.generate(() -> Ingredient.func_199566_b((PacketBuffer)buffer)).limit(buffer.func_150792_a()).collect(Collectors.toList()));
        }
    }
}

