/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ContentMatchIngredient;
import knightminer.inspirations.library.recipe.cauldron.ingredient.FluidCauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredientSerializer;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class CauldronIngredients {
    private static final String KEY_TYPE = "type";
    private static final BiMap<ResourceLocation, ICauldronIngredientSerializer<?>> INGREDIENTS = HashBiMap.create();
    public static final FluidCauldronIngredient.Serializer FLUID = CauldronIngredients.register("fluid", new FluidCauldronIngredient.Serializer());
    public static final ContentMatchIngredient.Serializer<Integer> COLOR = CauldronIngredients.registerMatch(CauldronContentTypes.COLOR);
    public static final ContentMatchIngredient.Serializer<DyeColor> DYE = CauldronIngredients.registerMatch(CauldronContentTypes.DYE);
    public static final ContentMatchIngredient.Serializer<Potion> POTION = CauldronIngredients.registerMatch(CauldronContentTypes.POTION);
    public static final ContentMatchIngredient.Serializer<ResourceLocation> CUSTOM = CauldronIngredients.registerMatch(CauldronContentTypes.CUSTOM);

    public static void register(ResourceLocation name, ICauldronIngredientSerializer<?> type) {
        if (INGREDIENTS.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate cauldron ingredient serializer '" + name + "'");
        }
        INGREDIENTS.put((Object)name, type);
    }

    private static <T extends ICauldronIngredientSerializer<?>> T register(String name, T type) {
        CauldronIngredients.register(Inspirations.getResource(name), type);
        return type;
    }

    public static <C extends ICauldronContents, T> ContentMatchIngredient.Serializer<T> registerMatch(CauldronContentType<T> mapType) {
        ContentMatchIngredient.Serializer<T> serializer = new ContentMatchIngredient.Serializer<T>(mapType);
        CauldronIngredients.register(CauldronContentTypes.getName(mapType), serializer);
        return serializer;
    }

    private static <T extends ICauldronIngredient> ICauldronIngredientSerializer<T> getSerializer(T contents) {
        return contents.getSerializer();
    }

    public static ResourceLocation getName(ICauldronIngredientSerializer<?> serializer) {
        ResourceLocation name = (ResourceLocation)INGREDIENTS.inverse().get(serializer);
        if (name == null) {
            throw new IllegalArgumentException("Unregistered cauldron serializer");
        }
        return name;
    }

    public static <T extends ICauldronIngredient> JsonObject toJson(T contents) {
        JsonObject json = new JsonObject();
        ICauldronIngredientSerializer<T> serializer = CauldronIngredients.getSerializer(contents);
        json.addProperty(KEY_TYPE, CauldronIngredients.getName(serializer).toString());
        serializer.write(contents, json);
        return json;
    }

    public static ICauldronIngredient read(JsonObject json) {
        ResourceLocation location = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)KEY_TYPE));
        ICauldronIngredientSerializer serializer = (ICauldronIngredientSerializer)INGREDIENTS.get((Object)location);
        if (serializer != null) {
            return serializer.read(json);
        }
        throw new JsonSyntaxException("Invalid cauldron ingredient type '" + location + "'");
    }

    public static <T extends ICauldronIngredient> void write(T contents, PacketBuffer buffer) {
        ICauldronIngredientSerializer<T> serializer = CauldronIngredients.getSerializer(contents);
        buffer.func_192572_a(CauldronIngredients.getName(serializer));
        serializer.write(contents, buffer);
    }

    public static ICauldronIngredient read(PacketBuffer buffer) {
        ResourceLocation name = buffer.func_192575_l();
        ICauldronIngredientSerializer serializer = (ICauldronIngredientSerializer)INGREDIENTS.get((Object)name);
        if (serializer == null) {
            throw new DecoderException("Invalid cauldron ingredient type '" + name + "'");
        }
        return serializer.read(buffer);
    }
}

