/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.contents;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.recipes.recipe.cauldron.contents.CauldronContents;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.util.JsonHelper;

public abstract class CauldronContentType<T> {
    public static final ResourceLocation NO_TEXTURE = Inspirations.getResource("missingno");
    private final Map<T, ICauldronContents> cache = new HashMap<T, ICauldronContents>();
    private final Map<ICauldronContents, T> valueOverrides = new HashMap<ICauldronContents, T>();
    private final Function<T, ICauldronContents> constructor = val -> new CauldronContents<Object>(this, val);

    public ICauldronContents of(T value) {
        return this.cache.computeIfAbsent(value, this.constructor);
    }

    public void setValue(ICauldronContents instance, T value) {
        if (instance.getType() == this) {
            throw new IllegalArgumentException("Attempted to register override within the same type");
        }
        this.valueOverrides.put(instance, value);
    }

    public void setResult(T value, ICauldronContents instance) {
        Optional optional = instance.get(this);
        if (optional.isPresent()) {
            if (!optional.get().equals(value)) {
                throw new IllegalArgumentException("Override contents does not match the value type");
            }
        } else {
            this.valueOverrides.put(instance, value);
        }
        this.cache.put(value, instance);
    }

    public Optional<T> getOverrideValue(ICauldronContents instance) {
        return Optional.ofNullable(this.valueOverrides.get(instance));
    }

    public abstract ResourceLocation getTexture(T var1);

    public int getColor(T value) {
        return -1;
    }

    public abstract ITextComponent getDisplayName(T var1);

    public void addInformation(T value, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
    }

    @Nullable
    public String getModId(T value) {
        return null;
    }

    public abstract String getName(T var1);

    public String getKey() {
        return "name";
    }

    @Nullable
    public abstract T read(CompoundNBT var1);

    public void write(T value, CompoundNBT tag) {
        tag.func_74778_a(this.getKey(), this.getName(value));
    }

    public abstract T getValue(JsonElement var1, String var2);

    public JsonElement toJson(T value) {
        return new JsonPrimitive(this.getName(value));
    }

    public T read(JsonObject json) {
        String key = this.getKey();
        return this.getValue(JsonHelper.getElement((JsonObject)json, (String)key), key);
    }

    public void write(T value, JsonObject json) {
        json.addProperty(this.getKey(), this.getName(value));
    }

    public abstract T read(PacketBuffer var1);

    public abstract void write(T var1, PacketBuffer var2);

    public String toString() {
        return String.format("CauldronContentType[%s]", CauldronContentTypes.getName(this));
    }
}

