/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronState;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.LevelPredicate;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractCauldronRecipe
implements ICauldronRecipeDisplay {
    protected final ICauldronIngredient ingredient;
    protected final LevelPredicate level;
    protected final TemperaturePredicate temperature;
    @Nullable
    protected final ICauldronContents outputContents;
    private ICauldronContents displayContents;
    private FluidStack displayFluid;
    private List<FluidStack> fluidInputs;

    public AbstractCauldronRecipe(ICauldronIngredient ingredient, LevelPredicate level, TemperaturePredicate temperature, @Nullable ICauldronContents output) {
        this.ingredient = ingredient;
        this.level = level;
        this.temperature = temperature;
        this.outputContents = output;
    }

    protected boolean matches(ICauldronState state) {
        int currentLevel = state.getLevel();
        return this.temperature.test(state.getTemperature()) && this.level.test(currentLevel) && (currentLevel == 0 || this.ingredient.test(state.getContents()));
    }

    @Override
    public List<ICauldronContents> getContentInputs() {
        return this.ingredient.getMatchingContents();
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        if (this.fluidInputs == null) {
            List<ICauldronContents> inputs = this.getContentInputs();
            this.fluidInputs = inputs.stream().flatMap(contents -> DisplayCauldronRecipe.getFluid(contents).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            if (this.fluidInputs.size() != inputs.size()) {
                this.fluidInputs = Collections.emptyList();
            }
        }
        return this.fluidInputs;
    }

    @Override
    public TemperaturePredicate getTemperature() {
        return this.temperature;
    }

    @Override
    public ICauldronContents getContentOutput() {
        if (this.outputContents == null) {
            if (this.displayContents == null) {
                List<ICauldronContents> inputs = this.getContentInputs();
                this.displayContents = inputs.isEmpty() ? (ICauldronContents)CauldronContentTypes.DEFAULT.get() : inputs.get(0);
            }
            return this.displayContents;
        }
        return this.outputContents;
    }

    @Override
    public FluidStack getFluidOutput() {
        if (this.displayFluid == null) {
            this.displayFluid = DisplayCauldronRecipe.getFluid(this.getContentOutput()).orElse(FluidStack.EMPTY);
        }
        return this.displayFluid;
    }

    public static TemperaturePredicate getBoiling(JsonObject json, String key) {
        String name = JSONUtils.func_151219_a((JsonObject)json, (String)key, (String)"any");
        TemperaturePredicate boiling = TemperaturePredicate.byName(name);
        if (boiling == null) {
            throw new JsonSyntaxException("Invalid boiling predicate '" + name + "'");
        }
        return boiling;
    }
}

