/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.recipe;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronState;
import knightminer.inspirations.library.recipe.cauldron.recipe.AbstractCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronTransform;
import knightminer.inspirations.library.recipe.cauldron.util.LevelPredicate;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class CauldronTransform
extends AbstractCauldronRecipe
implements ICauldronTransform {
    private final ResourceLocation id;
    private final String group;
    private final int time;
    private final SoundEvent sound;

    public CauldronTransform(ResourceLocation id, String group, ICauldronIngredient ingredient, LevelPredicate level, TemperaturePredicate temperature, ICauldronContents output, int time, SoundEvent sound) {
        super(ingredient, level, temperature, output);
        this.id = id;
        this.group = group;
        this.time = time;
        this.sound = sound;
    }

    public boolean matches(ICauldronState inv, World worldIn) {
        return inv.getLevel() != 0 && this.matches(inv);
    }

    @Override
    public ICauldronContents getContentOutput(ICauldronState inv) {
        if (this.outputContents == null) {
            return inv.getContents();
        }
        return this.outputContents;
    }

    @Override
    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public List<ItemStack> getItemInputs() {
        return Collections.emptyList();
    }

    @Override
    public int getLevelInput() {
        return this.level.getMax();
    }

    @Override
    public int getLevelOutput() {
        return this.level.getMax();
    }

    @Override
    public ItemStack getItemOutput() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_TRANSFORM;
    }

    public static class Serializer
    extends RecipeSerializer<CauldronTransform> {
        public CauldronTransform read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ICauldronIngredient ingredient = CauldronIngredients.read(JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            TemperaturePredicate temperature = AbstractCauldronRecipe.getBoiling(json, "temperature");
            LevelPredicate level = json.has("level") ? LevelPredicate.read(JSONUtils.func_152754_s((JsonObject)json, (String)"level")) : LevelPredicate.range(1, 12);
            ICauldronContents output = CauldronContentTypes.read(JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            SoundEvent sound = SoundEvents.field_187621_J;
            if (json.has("sound")) {
                sound = CauldronRecipe.Serializer.getSound(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"sound")), sound);
            }
            return new CauldronTransform(id, group, ingredient, level, temperature, output, time, sound);
        }

        @Nullable
        public CauldronTransform read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            ICauldronIngredient ingredient = CauldronIngredients.read(buffer);
            TemperaturePredicate temperature = (TemperaturePredicate)buffer.func_179257_a(TemperaturePredicate.class);
            LevelPredicate level = LevelPredicate.read(buffer);
            ICauldronContents output = CauldronContentTypes.read(buffer);
            int time = buffer.func_150792_a();
            SoundEvent sound = CauldronRecipe.Serializer.getSound(buffer.func_192575_l(), SoundEvents.field_187621_J);
            return new CauldronTransform(id, group, ingredient, level, temperature, output, time, sound);
        }

        public void write(PacketBuffer buffer, CauldronTransform recipe) {
            buffer.func_180714_a(recipe.group);
            CauldronIngredients.write(recipe.ingredient, buffer);
            buffer.func_179249_a((Enum)recipe.temperature);
            recipe.level.write(buffer);
            ICauldronContents contents = recipe.outputContents == null ? (ICauldronContents)CauldronContentTypes.DEFAULT.get() : recipe.outputContents;
            contents.write(buffer);
            buffer.func_150787_b(recipe.time);
            buffer.func_192572_a(Objects.requireNonNull(recipe.sound.getRegistryName()));
        }
    }
}

