/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.util;

import com.google.gson.JsonObject;
import java.util.function.IntPredicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class LevelPredicate
implements IntPredicate {
    private static final String KEY_MIN = "min";
    private static final String KEY_MAX = "max";
    private static final LevelPredicate[] CACHE = new LevelPredicate[LevelPredicate.triangle(13)];
    private final int min;
    private final int max;

    private LevelPredicate(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static LevelPredicate min(int min) {
        return LevelPredicate.range(min, 12);
    }

    public static LevelPredicate max(int max) {
        return LevelPredicate.range(0, max);
    }

    public static LevelPredicate range(int min, int max) {
        if (min < 0 || min > 12) {
            throw new IllegalArgumentException("Invalid minimum level " + min + ", must be between 0 and 12");
        }
        if (max < 0 || max > 12) {
            throw new IllegalArgumentException("Invalid maximum level " + max + ", must be between 0 and 12");
        }
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be larger than maximum");
        }
        int cacheKey = LevelPredicate.triangle(min) + max;
        if (CACHE[cacheKey] == null) {
            LevelPredicate.CACHE[cacheKey] = new LevelPredicate(min, max);
        }
        return CACHE[cacheKey];
    }

    public static LevelPredicate read(JsonObject json) {
        int min = JSONUtils.func_151208_a((JsonObject)json, (String)KEY_MIN, (int)0);
        int max = JSONUtils.func_151208_a((JsonObject)json, (String)KEY_MAX, (int)12);
        return LevelPredicate.range(min, max);
    }

    public static LevelPredicate read(PacketBuffer buffer) {
        int min = buffer.func_150792_a();
        int max = buffer.func_150792_a();
        return LevelPredicate.range(min, max);
    }

    @Override
    public boolean test(int value) {
        return value >= this.min && value <= this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.min);
        buffer.func_150787_b(this.max);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        if (this.min > 0) {
            object.addProperty(KEY_MIN, (Number)this.min);
        }
        if (this.max < 12) {
            object.addProperty(KEY_MAX, (Number)this.max);
        }
        return object;
    }

    public String toString() {
        return String.format("LevelPredicate[%d,%d]", this.min, this.max);
    }

    private static int triangle(int num) {
        return num * (num + 1) / 2;
    }
}

