/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.util;

import com.google.gson.JsonObject;
import io.netty.handler.codec.DecoderException;
import java.util.Locale;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;

public abstract class LevelUpdate
implements IntUnaryOperator {
    private static final String KEY_ADD = "add";
    private static final String KEY_SET = "set";
    private static final LevelUpdate[] ADD_CACHE = new LevelUpdate[25];
    private static final LevelUpdate[] SET_CACHE = new LevelUpdate[13];
    public static final LevelUpdate IDENTITY;

    private LevelUpdate() {
    }

    public static LevelUpdate add(int amount) {
        if (amount < -12 || amount > 12) {
            throw new IllegalArgumentException("Invalid amount " + amount + ", must be between -12 and 12");
        }
        int key = amount + 12;
        if (ADD_CACHE[key] == null) {
            LevelUpdate.ADD_CACHE[key] = new Add(amount);
        }
        return ADD_CACHE[key];
    }

    public static LevelUpdate set(int amount) {
        if (amount < 0 || amount > 12) {
            throw new IllegalArgumentException("Invalid amount " + amount + ", must be between 0 and 12");
        }
        if (SET_CACHE[amount] == null) {
            LevelUpdate.SET_CACHE[amount] = new Set(amount);
        }
        return SET_CACHE[amount];
    }

    public static LevelUpdate read(JsonObject json) {
        if (json.has(KEY_ADD)) {
            return new Add(JSONUtils.func_151203_m((JsonObject)json, (String)KEY_ADD));
        }
        if (json.has(KEY_SET)) {
            return new Set(JSONUtils.func_151203_m((JsonObject)json, (String)KEY_SET));
        }
        return IDENTITY;
    }

    public static LevelUpdate read(PacketBuffer buffer) {
        Type type = (Type)buffer.func_179257_a(Type.class);
        switch (type) {
            case IDENTITY: {
                return IDENTITY;
            }
            case SET: {
                return new Set(buffer.func_150792_a());
            }
            case ADD: {
                return new Add(buffer.func_150792_a());
            }
        }
        throw new DecoderException("Got null type, this should not be possible");
    }

    public abstract void write(PacketBuffer var1);

    protected void write(JsonObject json) {
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        this.write(object);
        return object;
    }

    static {
        LevelUpdate.ADD_CACHE[12] = IDENTITY = new LevelUpdate(){

            @Override
            public void write(PacketBuffer buffer) {
                buffer.func_179249_a((Enum)Type.IDENTITY);
            }

            @Override
            public int applyAsInt(int original) {
                return original;
            }

            @Override
            public JsonObject toJson() {
                return new JsonObject();
            }

            public String toString() {
                return "LevelUpdate.Identity";
            }
        };
    }

    private static enum Type {
        IDENTITY,
        SET,
        ADD;

        private final String name = this.name().toLowerCase(Locale.US);

        public String getName() {
            return this.name;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }

    private static class Add
    extends LevelUpdate {
        private final int amount;

        private Add(int amount) {
            this.amount = amount;
        }

        @Override
        public int applyAsInt(int original) {
            return MathHelper.func_76125_a((int)(original + this.amount), (int)0, (int)12);
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)Type.ADD);
            buffer.func_150787_b(this.amount);
        }

        @Override
        protected void write(JsonObject json) {
            json.addProperty(LevelUpdate.KEY_ADD, (Number)this.amount);
        }

        public String toString() {
            return String.format("LevelUpdate.Add(%+d)", this.amount);
        }
    }

    private static class Set
    extends LevelUpdate {
        private final int amount;

        private Set(int amount) {
            this.amount = amount;
        }

        @Override
        public int applyAsInt(int original) {
            return this.amount;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)Type.SET);
            buffer.func_150787_b(this.amount);
        }

        @Override
        protected void write(JsonObject json) {
            json.addProperty(LevelUpdate.KEY_SET, (Number)this.amount);
        }

        public String toString() {
            return String.format("LevelUpdate.Set(=%d)", this.amount);
        }
    }
}

