/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class DyeCauldronWaterRecipe
implements ICauldronRecipe,
ICauldronRecipeDisplay {
    private final ResourceLocation id;
    private final DyeColor dye;
    private List<ItemStack> inputs;

    public DyeCauldronWaterRecipe(ResourceLocation id, DyeColor dye) {
        this.id = id;
        this.dye = dye;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        if (inv.getLevel() == 0 || !this.dye.getTag().func_230235_a_((Object)stack.func_77973_b()) || !stack.getContainerItem().func_190926_b()) {
            return false;
        }
        ICauldronContents contents = inv.getContents();
        return contents.contains(CauldronContentTypes.FLUID, Fluids.field_204546_a) || contents.get(CauldronContentTypes.COLOR).filter(color -> color.intValue() != this.dye.getColorValue()).isPresent();
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        ICauldronContents contents = inv.getContents();
        if (contents.contains(CauldronContentTypes.FLUID, Fluids.field_204546_a)) {
            inv.shrinkStack(1);
            inv.setContents(CauldronContentTypes.DYE.of(this.dye));
            inv.playSound(SoundEvents.field_187609_F);
        } else {
            contents.get(CauldronContentTypes.COLOR).ifPresent(color -> {
                inv.shrinkStack(1);
                inv.setContents(CauldronContentTypes.COLOR.of(DyeCauldronWaterRecipe.addColors(this.dye.getColorValue(), 1, color, 1)));
                inv.playSound(SoundEvents.field_187547_bF);
            });
        }
    }

    public static int addColors(int newColor, int newLevels, int original, int origLevels) {
        int nr = DyeCauldronWaterRecipe.getRed(newColor);
        int ng = DyeCauldronWaterRecipe.getGreen(newColor);
        int nb = DyeCauldronWaterRecipe.getBlue(newColor);
        int r = nr * newLevels + DyeCauldronWaterRecipe.getRed(original) * origLevels;
        int g = ng * newLevels + DyeCauldronWaterRecipe.getGreen(original) * origLevels;
        int b = nb * newLevels + DyeCauldronWaterRecipe.getBlue(original) * origLevels;
        int c = origLevels + newLevels;
        return DyeCauldronWaterRecipe.divide(r, nr, c) << 16 | DyeCauldronWaterRecipe.divide(g, ng, c) << 8 | DyeCauldronWaterRecipe.divide(b, nb, c);
    }

    private static int divide(int sum, int pref, int divisor) {
        int color = sum / divisor;
        if (sum % divisor != 0 && pref > color) {
            ++color;
        }
        return color;
    }

    private static int getRed(int color) {
        return (color & 0xFF0000) >> 16;
    }

    private static int getGreen(int color) {
        return (color & 0xFF00) >> 8;
    }

    private static int getBlue(int color) {
        return color & 0xFF;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_DYE_WATER;
    }

    @Override
    public List<ItemStack> getItemInputs() {
        if (this.inputs == null) {
            this.inputs = this.dye.getTag().func_230236_b_().stream().map(ItemStack::new).filter(stack -> !stack.hasContainerItem()).collect(Collectors.toList());
            if (this.inputs.isEmpty()) {
                this.inputs = Collections.singletonList(new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)this.dye)));
            }
        }
        return this.inputs;
    }

    @Override
    public List<ICauldronContents> getContentInputs() {
        return (List)DisplayCauldronRecipe.WATER_CONTENTS.get();
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        return (List)DisplayCauldronRecipe.WATER_FLUID.get();
    }

    @Override
    public ICauldronContents getContentOutput() {
        return CauldronContentTypes.DYE.of(this.dye);
    }

    @Override
    public int getLevelInput() {
        return 4;
    }

    @Override
    public int getLevelOutput() {
        return 4;
    }

    @Override
    public TemperaturePredicate getTemperature() {
        return TemperaturePredicate.ANY;
    }

    @Override
    public ItemStack getItemOutput() {
        return ItemStack.field_190927_a;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final DyeColor dye;

        public FinishedRecipe(ResourceLocation id, DyeColor dye) {
            super(id, RecipeSerializers.CAULDRON_DYE_WATER);
            this.dye = dye;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.addProperty("dye", this.dye.func_176610_l());
        }
    }

    public static class Serializer
    extends RecipeSerializer<DyeCauldronWaterRecipe> {
        public DyeCauldronWaterRecipe read(ResourceLocation id, JsonObject json) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"dye");
            DyeColor dye = DyeColor.func_204271_a((String)name, null);
            if (dye == null) {
                throw new JsonSyntaxException("Invalid color " + name);
            }
            return new DyeCauldronWaterRecipe(id, dye);
        }

        @Nullable
        public DyeCauldronWaterRecipe read(ResourceLocation id, PacketBuffer buffer) {
            return new DyeCauldronWaterRecipe(id, (DyeColor)buffer.func_179257_a(DyeColor.class));
        }

        public void write(PacketBuffer buffer, DyeCauldronWaterRecipe recipe) {
            buffer.func_179249_a((Enum)recipe.dye);
        }
    }
}

