/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FillBucketCauldronRecipe
implements ICauldronRecipe {
    private final ResourceLocation id;

    public FillBucketCauldronRecipe(ResourceLocation id) {
        this.id = id;
    }

    private static boolean tryFill(IFluidHandlerItem handler, Fluid fluid, IFluidHandler.FluidAction action) {
        return handler.fill(new FluidStack(fluid, 1000), action) == 1000;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack;
        if (inv.getLevel() < 12) {
            return false;
        }
        if (inv.getStack().func_190916_E() != 1) {
            stack = inv.getStack().func_77946_l();
            stack.func_190920_e(1);
        } else {
            stack = inv.getStack();
        }
        return inv.getContents().get(CauldronContentTypes.FLUID).flatMap(fluid -> FluidUtil.getFluidHandler((ItemStack)stack).filter(handler -> FillBucketCauldronRecipe.tryFill(handler, fluid, IFluidHandler.FluidAction.SIMULATE))).isPresent();
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        ItemStack stack = inv.splitStack(1);
        inv.getContents().get(CauldronContentTypes.FLUID).ifPresent(fluid -> FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(handler -> {
            if (FillBucketCauldronRecipe.tryFill(handler, fluid, IFluidHandler.FluidAction.EXECUTE)) {
                inv.setLevel(0);
                inv.setOrGiveStack(handler.getContainer());
                SoundEvent sound = fluid.getAttributes().getFillSound();
                if (sound == null) {
                    sound = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                }
                inv.playSound(sound);
            }
        }));
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_FILL_BUCKET;
    }
}

