/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.recipes.recipe.cauldron.DyeCauldronWaterRecipe;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.util.JsonHelper;

public class MixCauldronDyeRecipe
implements ICauldronRecipe,
ICauldronRecipeDisplay {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    @Nullable
    private final Integer color;
    private List<ItemStack> inputDisplay;
    private ItemStack outputDisplay;
    private ICauldronContents outputContents;

    public MixCauldronDyeRecipe(ResourceLocation id, Ingredient ingredient, @Nullable Integer color) {
        this.id = id;
        this.ingredient = ingredient;
        this.color = color;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        int level = inv.getLevel();
        if (level == 12) {
            return false;
        }
        ICauldronContents contents = inv.getContents();
        return (level == 0 || contents.contains(CauldronContentTypes.FLUID, Fluids.field_204546_a) || contents.contains(CauldronContentTypes.COLOR)) && this.ingredient.test(inv.getStack());
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        int newColor = this.color == null ? Util.getColor(inv.getStack()) : this.color;
        ICauldronContents contents = inv.getContents();
        ItemStack container = inv.getStack().getContainerItem();
        if (inv.getLevel() == 0 || contents.contains(CauldronContentTypes.FLUID, Fluids.field_204546_a)) {
            inv.shrinkStack(1);
            inv.giveStack(container.func_77946_l());
            int originalLevel = inv.getLevel();
            inv.addLevel(4);
            inv.setContents(CauldronContentTypes.COLOR.of(DyeCauldronWaterRecipe.addColors(newColor, 4, 0x808080, originalLevel)));
            inv.playSound(SoundEvents.field_191241_J);
        } else {
            contents.get(CauldronContentTypes.COLOR).ifPresent(color -> {
                inv.shrinkStack(1);
                inv.giveStack(container.func_77946_l());
                inv.addLevel(4);
                inv.setContents(CauldronContentTypes.COLOR.of(DyeCauldronWaterRecipe.addColors(newColor, 4, color, inv.getLevel())));
                inv.playSound(SoundEvents.field_191241_J);
            });
        }
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_MIX_DYE;
    }

    @Override
    public List<ItemStack> getItemInputs() {
        if (this.inputDisplay == null) {
            this.inputDisplay = Arrays.asList(this.ingredient.func_193365_a());
        }
        return this.inputDisplay;
    }

    @Override
    public List<ICauldronContents> getContentInputs() {
        return Collections.emptyList();
    }

    @Override
    public int getLevelInput() {
        return 0;
    }

    @Override
    public int getLevelOutput() {
        return 4;
    }

    @Override
    public ItemStack getItemOutput() {
        if (this.outputDisplay == null) {
            ItemStack[] items = this.ingredient.func_193365_a();
            this.outputDisplay = items.length != 0 ? items[0].getContainerItem() : ItemStack.field_190927_a;
        }
        return this.outputDisplay;
    }

    @Override
    public ICauldronContents getContentOutput() {
        if (this.outputContents == null) {
            assert (this.color != null);
            this.outputContents = CauldronContentTypes.COLOR.of(this.color);
        }
        return this.outputContents;
    }

    @Override
    public boolean isSimple() {
        return this.color != null;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final Ingredient ingredient;
        @Nullable
        private final Integer color;

        public FinishedRecipe(ResourceLocation id, Ingredient ingredient, Integer color) {
            super(id, RecipeSerializers.CAULDRON_MIX_DYE);
            this.ingredient = ingredient;
            this.color = color;
        }

        public FinishedRecipe(ResourceLocation id, Ingredient ingredient) {
            super(id, RecipeSerializers.CAULDRON_MIX_DYE);
            this.ingredient = ingredient;
            this.color = null;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            if (this.color != null) {
                json.addProperty("color", Integer.toHexString(this.color));
            }
        }
    }

    public static class Serializer
    extends RecipeSerializer<MixCauldronDyeRecipe> {
        public MixCauldronDyeRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            Integer color = null;
            if (json.has("color")) {
                String colorText = JSONUtils.func_151200_h((JsonObject)json, (String)"color");
                DyeColor dye = DyeColor.func_204271_a((String)colorText, null);
                if (dye != null) {
                    color = dye.getColorValue();
                } else {
                    try {
                        color = Integer.parseInt(JSONUtils.func_151200_h((JsonObject)json, (String)"color"), 16);
                    }
                    catch (NumberFormatException e) {
                        throw new JsonSyntaxException("Invalid color string '" + colorText + "'");
                    }
                }
            }
            return new MixCauldronDyeRecipe(id, ingredient, color);
        }

        @Nullable
        public MixCauldronDyeRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Integer color = null;
            if (buffer.readBoolean()) {
                color = buffer.readInt();
            }
            return new MixCauldronDyeRecipe(id, ingredient, color);
        }

        public void write(PacketBuffer buffer, MixCauldronDyeRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            if (recipe.color == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeInt(recipe.color.intValue());
            }
        }
    }
}

