/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tileentity.capability;

import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauldronFluidHandler
implements IFluidHandler {
    private final CauldronTileEntity cauldron;
    private FluidStack currentContents;

    public CauldronFluidHandler(CauldronTileEntity cauldron) {
        this.cauldron = cauldron;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.hasTag()) {
            return 0;
        }
        int level = this.cauldron.getLevel();
        if (level < 9) {
            int toInsert;
            Fluid fluid = stack.getFluid();
            if ((level > 0 || this.getFluidStack().getFluid() == fluid) && (toInsert = Math.min(CauldronFluidHandler.getLevels(stack.getAmount()), 12 - level)) != 0) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.cauldron.updateStateAndBlock(CauldronContentTypes.FLUID.of(fluid), toInsert + level);
                }
                return CauldronFluidHandler.getAmount(toInsert);
            }
        }
        return 0;
    }

    private FluidStack drain(Fluid fluid, int maxDrain, IFluidHandler.FluidAction action) {
        int toDrain;
        int level = this.cauldron.getLevel();
        if (level >= 3 && (toDrain = Math.min(CauldronFluidHandler.getLevels(maxDrain), level)) > 0) {
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.cauldron.updateStateAndBlock(null, level - toDrain);
            }
            return new FluidStack(fluid, CauldronFluidHandler.getAmount(toDrain));
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        FluidStack current = this.getFluidStack();
        if (!current.isEmpty() && !stack.hasTag() && current.getFluid() == stack.getFluid()) {
            return this.drain(stack.getFluid(), stack.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current = this.getFluidStack();
        if (!current.isEmpty()) {
            return this.drain(current.getFluid(), maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return !stack.hasTag();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluidStack();
    }

    public void clearCache() {
        this.currentContents = null;
    }

    private FluidStack getFluidStack() {
        if (this.currentContents == null) {
            this.currentContents = this.cauldron.getContents().get(CauldronContentTypes.FLUID).map(fluid -> new FluidStack(fluid, CauldronFluidHandler.getAmount(this.cauldron.getLevel()))).orElse(FluidStack.EMPTY);
        }
        return this.currentContents;
    }

    private static int getLevels(int amount) {
        return MathHelper.func_76125_a((int)(amount * 4 / 1000), (int)0, (int)4) * 3;
    }

    private static int getAmount(int levels) {
        return MathHelper.func_76125_a((int)(levels / 3 * 1000 / 4), (int)0, (int)1000);
    }
}

