/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import java.util.Random;
import java.util.function.Supplier;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class BlockCropBlock
extends CropsBlock
implements IHidable,
IPlantable {
    public static final IntegerProperty LARGE_AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)14);
    protected Supplier<Block> block;
    protected PlantType type;

    protected BlockCropBlock(Supplier<Block> block, PlantType type, AbstractBlock.Properties props) {
        super(props);
        this.block = block;
        this.type = type;
    }

    protected BlockCropBlock(Block block, PlantType type) {
        this((Supplier<Block>)block.delegate, type, AbstractBlock.Properties.func_200950_a((AbstractBlock)block));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.func_185524_e()});
    }

    public IntegerProperty func_185524_e() {
        return LARGE_AGE;
    }

    public int func_185526_g() {
        return 15;
    }

    public BlockState func_185528_e(int age) {
        if (age == this.func_185526_g()) {
            return this.block.get().func_176223_P();
        }
        return super.func_185528_e(age);
    }

    public boolean func_185525_y(BlockState state) {
        return false;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int max;
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        int age = this.func_185527_x(state);
        if (age < (max = this.func_185526_g()) && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            BlockState newState = this.func_185528_e(++age);
            if (age == max) {
                world.func_180501_a(pos, newState, 3);
                if (!newState.func_196955_c((IWorldReader)world, pos)) {
                    world.func_205220_G_().func_205360_a(pos, (Object)this.block.get(), 1);
                }
            } else {
                world.func_180501_a(pos, newState, 2);
            }
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return this.type;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return this.block.get().func_196260_a(this.block.get().func_176223_P(), world, pos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)Config.bonemealBlockCrop.get();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (Boolean)Config.bonemealBlockCrop.get();
    }

    protected IPlantable getPlant() {
        Block block = this.block.get();
        if (block instanceof IPlantable) {
            return (IPlantable)block;
        }
        return this;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableBlockCrops.get();
    }
}

