/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.block.FittedCarpetBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FlatCarpetBlock
extends CarpetBlock {
    protected static final BooleanProperty NORTHWEST = BooleanProperty.func_177716_a((String)"northwest");
    protected static final BooleanProperty NORTHEAST = BooleanProperty.func_177716_a((String)"northeast");
    protected static final BooleanProperty SOUTHWEST = BooleanProperty.func_177716_a((String)"southwest");
    protected static final BooleanProperty SOUTHEAST = BooleanProperty.func_177716_a((String)"southeast");
    private static final int SHAPE_FLAT = 0;

    public FlatCarpetBlock(DyeColor color, AbstractBlock.Properties props) {
        super(color, props);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int shape = FlatCarpetBlock.getStairShape(world.func_180495_p(pos.func_177977_b()));
        if (shape != 0) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((FittedCarpetBlock)InspirationsTweaks.fitCarpets.get((Enum)this.func_196547_d())).func_176223_P().func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf((shape & 8) > 0))).func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf((shape & 4) > 0))).func_206870_a((Property)SOUTHWEST, (Comparable)Boolean.valueOf((shape & 2) > 0))).func_206870_a((Property)SOUTHEAST, (Comparable)Boolean.valueOf((shape & 1) > 0));
        }
        return ((FlatCarpetBlock)InspirationsTweaks.flatCarpets.get((Enum)this.func_196547_d())).func_176223_P();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        world.func_180501_a(pos, this.func_196271_a(state, null, null, (IWorld)world, pos, null), 2);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)InspirationsTweaks.flatCarpets.get((Enum)this.func_196547_d()));
    }

    private static int getStairShape(BlockState stairs) {
        if (!((Boolean)Config.enableFittedCarpets.get()).booleanValue()) {
            return 0;
        }
        if (!(stairs.func_177230_c() instanceof StairsBlock) || stairs.func_177229_b((Property)StairsBlock.field_176308_b) != Half.BOTTOM) {
            return 0;
        }
        StairsShape shape = (StairsShape)stairs.func_177229_b((Property)StairsBlock.field_176310_M);
        switch ((Direction)stairs.func_177229_b((Property)StairsBlock.field_176309_a)) {
            case NORTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 3;
                    }
                    case INNER_LEFT: {
                        return 1;
                    }
                    case INNER_RIGHT: {
                        return 2;
                    }
                    case OUTER_LEFT: {
                        return 7;
                    }
                    case OUTER_RIGHT: {
                        return 11;
                    }
                }
            }
            case SOUTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 12;
                    }
                    case INNER_LEFT: {
                        return 8;
                    }
                    case INNER_RIGHT: {
                        return 4;
                    }
                    case OUTER_LEFT: {
                        return 14;
                    }
                    case OUTER_RIGHT: {
                        return 13;
                    }
                }
            }
            case WEST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 5;
                    }
                    case INNER_LEFT: {
                        return 4;
                    }
                    case INNER_RIGHT: {
                        return 1;
                    }
                    case OUTER_LEFT: {
                        return 13;
                    }
                    case OUTER_RIGHT: {
                        return 7;
                    }
                }
            }
            case EAST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 10;
                    }
                    case INNER_LEFT: {
                        return 2;
                    }
                    case INNER_RIGHT: {
                        return 8;
                    }
                    case OUTER_LEFT: {
                        return 11;
                    }
                    case OUTER_RIGHT: {
                        return 14;
                    }
                }
            }
        }
        return 0;
    }
}

