/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TorchLeverBlock
extends TorchBlock {
    private static final DirectionProperty SWING = DirectionProperty.func_177712_a((String)"swing", dir -> dir != Direction.DOWN);

    public TorchLeverBlock(AbstractBlock.Properties props, IParticleData particles) {
        super(props, particles);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)SWING, (Comparable)Direction.UP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SWING});
    }

    private boolean isPowered(BlockState state) {
        return state.func_177229_b((Property)SWING) != Direction.UP;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        Direction swing = (Direction)state.func_177229_b((Property)SWING);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        if (this.isPowered(state)) {
            int offsetX = swing.func_82601_c();
            int offsetZ = swing.func_82599_e();
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.23 * (double)offsetX, y - 0.05, z + 0.23 * (double)offsetZ, 0.0, 0.0, 0.0);
            world.func_195594_a(this.field_235607_e_, x + 0.23 * (double)offsetX, y - 0.05, z + 0.23 * (double)offsetZ, 0.0, 0.0, 0.0);
        } else {
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
            world.func_195594_a(this.field_235607_e_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        float pitch;
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (this.isPowered(state)) {
            state = (BlockState)state.func_206870_a((Property)SWING, (Comparable)Direction.UP);
            pitch = 0.5f;
        } else {
            state = (BlockState)state.func_206870_a((Property)SWING, (Comparable)player.func_174811_aO());
            pitch = 0.6f;
        }
        world.func_180501_a(pos, state, 3);
        world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, pitch);
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177977_b(), (Block)this);
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c() && !isMoving && this.isPowered(state)) {
            world.func_195593_d(pos, (Block)this);
            world.func_195593_d(pos.func_177977_b(), (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.isPowered(state) ? 15 : 0;
    }

    @Deprecated
    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (!this.isPowered(state)) {
            return 0;
        }
        return side == Direction.DOWN ? 15 : 0;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }
}

