/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventFactory;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.RecipeUpdateEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.rei.PluginDetector;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.entry.renderer.EntryRendererRegistryImpl;
import me.shedaniel.rei.impl.client.favorites.DelegatingFavoriteEntryProviderImpl;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.client.registry.category.CategoryRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.screen.ScreenRegistryImpl;
import me.shedaniel.rei.impl.client.search.SearchProviderImpl;
import me.shedaniel.rei.impl.client.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.impl.client.transfer.TransferHandlerRegistryImpl;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.util.IssuesDetector;
import me.shedaniel.rei.plugin.test.REITestPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.GhostRecipe;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.container.Slot;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RoughlyEnoughItemsCoreClient {
    public static final Event<RecipeUpdateEvent> PRE_UPDATE_RECIPES = EventFactory.createLoop((Object[])new RecipeUpdateEvent[0]);
    @ApiStatus.Experimental
    public static boolean isLeftMousePressed = false;
    private static final ExecutorService RELOAD_PLUGINS = Executors.newSingleThreadScheduledExecutor(task -> {
        Thread thread = new Thread(task, "REI-ReloadPlugins");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(($, exception) -> RoughlyEnoughItemsCore.LOGGER.throwException(exception));
        return thread;
    });

    public static void attachClientInternals() {
        InternalWidgets.attach();
        EmptyEntryDefinition.EmptyRenderer emptyEntryRenderer = new EmptyEntryDefinition.EmptyRenderer();
        ClientInternals.attachInstance(() -> emptyEntryRenderer, "emptyEntryRenderer");
        ClientInternals.attachInstance(DelegatingFavoriteEntryProviderImpl::new, "delegateFavoriteEntry");
        ClientInternals.attachInstance(object -> {
            String type = object.func_74779_i("type");
            ResourceLocation id = new ResourceLocation(type);
            FavoriteEntryType entryType = FavoriteEntryType.registry().get(id);
            if (entryType == null) {
                return DataResult.error((String)("Unknown favorite type: " + id + ", json: " + object));
            }
            return entryType.readResult((CompoundNBT)object);
        }, "favoriteEntryFromJson");
        ClientInternals.attachInstance(QueuedTooltip::impl, "tooltipProvider");
        ClientInternals.attachInstance(successful -> new ClickArea.Result((Boolean)successful){
            private List<CategoryIdentifier<?>> categories = Lists.newArrayList();
            final /* synthetic */ Boolean val$successful;
            {
                this.val$successful = bl;
            }

            @Override
            public ClickArea.Result category(CategoryIdentifier<?> category) {
                this.categories.add(category);
                return this;
            }

            @Override
            public boolean isSuccessful() {
                return this.val$successful;
            }

            @Override
            public Stream<CategoryIdentifier<?>> getCategories() {
                return this.categories.stream();
            }
        }, "clickAreaHandlerResult");
        ClientInternals.attachInstanceSupplier(new PluginManagerImpl<REIClientPlugin>(REIClientPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> RoughlyEnoughItemsCore.LOGGER.info("Reloaded Plugin Manager [%s] with %d entries, %d displays, %d display visibility predicates, %d categories (%s), %d exclusion zones and %d overlay deciders in %dms.", REIClientPlugin.class.getSimpleName(), EntryRegistry.getInstance().size(), DisplayRegistry.getInstance().displaySize(), DisplayRegistry.getInstance().getVisibilityPredicates().size(), CategoryRegistry.getInstance().size(), CategoryRegistry.getInstance().stream().map(CategoryRegistry.CategoryConfiguration::getCategory).map(DisplayCategory::getTitle).map(ITextComponent::getString).collect(Collectors.joining(", ")), ScreenRegistry.getInstance().exclusionZones().getZonesCount(), ScreenRegistry.getInstance().getDeciders().size(), usedTime), new EntryRendererRegistryImpl(), new ViewsImpl(), new SearchProviderImpl(), new ConfigManagerImpl(), new EntryRegistryImpl(), new CategoryRegistryImpl(), new DisplayRegistryImpl(), new ScreenRegistryImpl(), new FavoriteEntryTypeRegistryImpl(), new SubsetsRegistryImpl(), new TransferHandlerRegistryImpl(), new REIRuntimeImpl()), "clientPluginManager");
    }

    public void onInitializeClient() {
        IssuesDetector.detect();
        this.registerEvents();
        PluginDetector.detectClientPlugins();
        this.loadTestPlugins();
        Minecraft client = Minecraft.func_71410_x();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (buf, context) -> {
            ItemStack stack = buf.func_150791_c();
            String player = buf.func_150789_c(Short.MAX_VALUE);
            if (client.field_71439_g != null) {
                client.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", EntryStacks.of(stack.func_77946_l()).asFormattedText().getString()).replaceAll("\\{item_count}", stack.func_77946_l().func_190916_E() + "").replaceAll("\\{player_name}", player)), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.NOT_ENOUGH_ITEMS_PACKET, (buf, context) -> {
            Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
            if (currentScreen instanceof CraftingScreen) {
                CraftingScreen craftingScreen = (CraftingScreen)currentScreen;
                RecipeBookGui recipeBookGui = craftingScreen.func_194310_f();
                GhostRecipe ghostSlots = recipeBookGui.field_191915_z;
                ghostSlots.func_192682_a();
                ArrayList input = Lists.newArrayList();
                int mapSize = buf.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    ArrayList list = Lists.newArrayList();
                    int count = buf.readInt();
                    for (int j = 0; j < count; ++j) {
                        list.add(buf.func_150791_c());
                    }
                    input.add(list);
                }
                ghostSlots.func_194187_a(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221574_b}), 381203812, 12738291);
                WorkbenchContainer container = (WorkbenchContainer)craftingScreen.func_212873_a_();
                for (int i = 0; i < input.size(); ++i) {
                    List stacks = (List)input.get(i);
                    if (stacks.isEmpty()) continue;
                    Slot slot = container.func_75139_a(i + container.func_201767_f() + 1);
                    ghostSlots.func_194187_a(Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[0])), slot.field_75223_e, slot.field_75221_f);
                }
            }
        });
    }

    private void loadTestPlugins() {
        if (System.getProperty("rei.test", "false").equals("true")) {
            PluginView.getClientInstance().registerPlugin(new REITestPlugin());
        }
    }

    public static boolean shouldReturn(Screen screen) {
        if (!REIRuntime.getInstance().getOverlay().isPresent()) {
            return true;
        }
        if (screen == null) {
            return true;
        }
        if (screen != Minecraft.func_71410_x().field_71462_r) {
            return true;
        }
        return RoughlyEnoughItemsCoreClient._shouldReturn(screen);
    }

    private static ScreenOverlay getOverlay() {
        return REIRuntime.getInstance().getOverlay().orElseThrow(() -> new IllegalStateException("Overlay not initialized!"));
    }

    private static boolean _shouldReturn(Screen screen) {
        try {
            Class<?> screenClass = screen.getClass();
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders()) {
                ActionResultType result;
                if (!decider.isHandingScreen(screen.getClass()) || (result = decider.shouldScreenBeOverlaid(screenClass)) == ActionResultType.PASS) continue;
                return result == ActionResultType.FAIL || REIRuntime.getInstance().getPreviousScreen() == null;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return true;
    }

    private void registerEvents() {
        Minecraft client = Minecraft.func_71410_x();
        ResourceLocation recipeButtonTex = new ResourceLocation("textures/gui/recipe_button.png");
        MutableLong startReload = new MutableLong(-1L);
        MutableLong endReload = new MutableLong(-1L);
        PRE_UPDATE_RECIPES.register(recipeManager -> {
            RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.clear();
            RoughlyEnoughItemsCoreClient.reloadPlugins(startReload, ReloadStage.START);
        });
        RecipeUpdateEvent.EVENT.register(recipeManager -> {
            if (!Platform.isFabric()) {
                RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.clear();
            }
            RoughlyEnoughItemsCoreClient.reloadPlugins(endReload, Platform.isFabric() ? ReloadStage.END : null);
        });
        GuiEvent.INIT_POST.register((screen, widgets, children) -> {
            REIRuntime.getInstance().getOverlay(false, true);
            REIRuntimeImpl.getInstance().setPreviousScreen(screen);
            if (ConfigObject.getInstance().doesDisableRecipeBook() && screen instanceof ContainerScreen) {
                widgets.removeIf(widget -> widget instanceof ImageButton && ((ImageButton)widget).field_191750_o.equals((Object)recipeButtonTex));
                screen.func_231039_at__().removeIf(widget -> widget instanceof ImageButton && ((ImageButton)widget).field_191750_o.equals((Object)recipeButtonTex));
            }
        });
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = true;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().func_231044_a_(mouseX, mouseY, button)) {
                if (button == 0) {
                    screen.func_231037_b__(true);
                }
                this.resetFocused(screen);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = false;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().func_231048_c_(mouseX, mouseY, button) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((minecraftClient, screen, mouseX, mouseY, amount) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().func_231043_a_(mouseX, mouseY, amount) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.CHAR_TYPED_PRE.register((minecraftClient, screen, character, keyCode) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().func_231042_a_(character, keyCode) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        GuiEvent.RENDER_POST.register((screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return;
            }
            this.resetFocused(screen);
            RoughlyEnoughItemsCoreClient.getOverlay().func_230430_a_(matrices, mouseX, mouseY, delta);
            ((ScreenOverlayImpl)RoughlyEnoughItemsCoreClient.getOverlay()).lateRender(matrices, mouseX, mouseY, delta);
            this.resetFocused(screen);
        });
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register((minecraftClient, screen, mouseX1, mouseY1, button, mouseX2, mouseY2) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().func_231045_a_(mouseX1, mouseY1, button, mouseX2, mouseY2) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
        ClientScreenInputEvent.KEY_PRESSED_PRE.register((minecraftClient, screen, i, i1, i2) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return ActionResultType.PASS;
            }
            if (screen instanceof ContainerScreen && ConfigObject.getInstance().doesDisableRecipeBook() && ConfigObject.getInstance().doesFixTabCloseContainer() && i == 258 && minecraftClient.field_71474_y.field_151445_Q.func_197976_a(i, i1)) {
                minecraftClient.field_71439_g.func_71053_j();
                return ActionResultType.SUCCESS;
            }
            if (screen.func_241217_q_() != null && screen.func_241217_q_() instanceof TextFieldWidget || screen.func_241217_q_() instanceof RecipeBookGui && ((RecipeBookGui)screen.func_241217_q_()).field_193962_q != null && ((RecipeBookGui)screen.func_241217_q_()).field_193962_q.func_230999_j_()) {
                return ActionResultType.PASS;
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().func_231046_a_(i, i1, i2) && this.resetFocused(screen)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
    }

    private boolean resetFocused(Screen screen) {
        if (screen.func_241217_q_() instanceof ScreenOverlay || screen.func_241217_q_() == screen) {
            screen.func_231035_a_(null);
        }
        return true;
    }

    @ApiStatus.Internal
    public static void reloadPlugins(MutableLong lastReload, @Nullable ReloadStage start) {
        if (lastReload != null) {
            if (lastReload.getValue() > 0L && System.currentTimeMillis() - lastReload.getValue() <= 5000L) {
                RoughlyEnoughItemsCore.LOGGER.warn("Suppressing Reload Plugins of stage " + (Object)((Object)start));
                return;
            }
            lastReload.setValue(System.currentTimeMillis());
        }
        if (ConfigObject.getInstance().doesRegisterRecipesInAnotherThread()) {
            CompletableFuture.runAsync(() -> RoughlyEnoughItemsCore._reloadPlugins(start), RELOAD_PLUGINS);
        } else {
            RoughlyEnoughItemsCore._reloadPlugins(start);
        }
    }
}

