/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Method;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.forge.RoughlyEnoughItemsInitializerImpl;
import net.minecraftforge.api.distmarker.Dist;

public class RoughlyEnoughItemsInitializer {
    public static void onInitialize() {
        RoughlyEnoughItemsState.env = RoughlyEnoughItemsInitializer.isClient() ? Dist.CLIENT : Dist.DEDICATED_SERVER;
        RoughlyEnoughItemsState.isDev = RoughlyEnoughItemsInitializer.isDev();
        RoughlyEnoughItemsInitializer.checkMods();
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            RoughlyEnoughItemsInitializer.initializeEntryPoint(false, "me.shedaniel.rei.RoughlyEnoughItemsCore");
        }
    }

    public static void onInitializeClient() {
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.RoughlyEnoughItemsCoreClient");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.REIModMenuEntryPoint");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.ClientHelperImpl");
            RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.REIRuntimeImpl");
        }
        RoughlyEnoughItemsInitializer.initializeEntryPoint(true, "me.shedaniel.rei.impl.client.ErrorDisplayer");
    }

    public static void initializeEntryPoint(boolean client, String className) {
        block9: {
            try {
                Class<?> name = Class.forName(className);
                Object instance = name.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = null;
                if (client) {
                    if (!RoughlyEnoughItemsInitializer.isClient()) break block9;
                    try {
                        method = name.getDeclaredMethod("onInitializeClient", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) {
                        method.invoke(instance, new Object[0]);
                    }
                    break block9;
                }
                try {
                    method = name.getDeclaredMethod("onInitialize", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    method.invoke(instance, new Object[0]);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to initialize REI entry point: " + className, e);
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return RoughlyEnoughItemsInitializerImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDev() {
        return RoughlyEnoughItemsInitializerImpl.isDev();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void checkMods() {
        RoughlyEnoughItemsInitializerImpl.checkMods();
    }
}

