/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.jetbrains.annotations.ApiStatus;

public interface DraggableStackVisitor<T extends Screen>
extends Comparable<DraggableStackVisitor<T>> {
    public static <T extends Screen> DraggableStackVisitor<T> from(final Supplier<Iterable<DraggableStackVisitor<T>>> visitors) {
        return new DraggableStackVisitor<T>(){

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DraggedAcceptorResult acceptDraggedStackWithResult(DraggingContext<T> context, DraggableStack stack) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    DraggedAcceptorResult result;
                    if (!visitor.isHandingScreen(context.getScreen()) || (result = Objects.requireNonNull(visitor.acceptDraggedStackWithResult(context, stack))) == DraggedAcceptorResult.PASS) continue;
                    return result;
                }
                return DraggedAcceptorResult.PASS;
            }

            @Override
            public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)visitors.get()).spliterator(), false).filter(visitor -> visitor.isHandingScreen(context.getScreen())).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, stack));
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public Optional<Acceptor> visitDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        return Optional.empty();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public boolean acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        Optional<Acceptor> acceptor = this.visitDraggedStack(context, stack);
        if (acceptor.isPresent()) {
            acceptor.get().accept(stack);
            return true;
        }
        return false;
    }

    default public DraggedAcceptorResult acceptDraggedStackWithResult(DraggingContext<T> context, DraggableStack stack) {
        return this.acceptDraggedStack(context, stack) ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS;
    }

    default public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
        return Stream.empty();
    }

    public <R extends Screen> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @FunctionalInterface
    public static interface Acceptor {
        public void accept(DraggableStack var1);
    }

    @FunctionalInterface
    public static interface BoundsProvider {
        public static VoxelShape fromRectangle(Rectangle bounds) {
            return VoxelShapes.func_197873_a((double)bounds.x, (double)bounds.y, (double)0.0, (double)bounds.getMaxX(), (double)bounds.getMaxY(), (double)0.1);
        }

        public static BoundsProvider ofRectangle(Rectangle bounds) {
            return BoundsProvider.ofShape(BoundsProvider.fromRectangle(bounds));
        }

        public static BoundsProvider ofRectangles(Iterable<Rectangle> bounds) {
            VoxelShape shape = StreamSupport.stream(bounds.spliterator(), false).map(BoundsProvider::fromRectangle).reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider ofShape(VoxelShape shape) {
            return () -> shape;
        }

        public static BoundsProvider ofShapes(Iterable<VoxelShape> shapes) {
            VoxelShape shape = StreamSupport.stream(shapes.spliterator(), false).reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
            return BoundsProvider.ofShape(shape);
        }

        public static BoundsProvider empty() {
            return VoxelShapes::func_197880_a;
        }

        public static BoundsProvider concat(Iterable<BoundsProvider> providers) {
            return () -> StreamSupport.stream(providers.spliterator(), false).map(BoundsProvider::bounds).reduce(VoxelShapes.func_197880_a(), VoxelShapes::func_197872_a);
        }

        public VoxelShape bounds();
    }
}

