/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface Tooltip {
    public static Tooltip create(@Nullable Point point, Collection<ITextComponent> texts) {
        return Tooltip.from(point, texts);
    }

    public static Tooltip create(@Nullable Point point, ITextComponent ... texts) {
        return Tooltip.create(point, Arrays.asList(texts));
    }

    public static Tooltip create(Collection<ITextComponent> texts) {
        return Tooltip.create(null, texts);
    }

    public static Tooltip create(ITextComponent ... texts) {
        return Tooltip.create(Arrays.asList(texts));
    }

    public static Tooltip from(@Nullable Point point, Collection<ITextComponent> entries) {
        return ClientInternals.createTooltip(point, entries);
    }

    public static Tooltip from(@Nullable Point point, ITextComponent ... entries) {
        return Tooltip.from(point, Arrays.asList(entries));
    }

    public static Tooltip from(Collection<ITextComponent> entries) {
        return Tooltip.from(null, entries);
    }

    public static Tooltip from(ITextComponent ... entries) {
        return Tooltip.from(Arrays.asList(entries));
    }

    public int getX();

    public int getY();

    public List<ITextComponent> getText();

    public Tooltip add(ITextComponent var1);

    default public Tooltip addAll(ITextComponent ... text) {
        for (ITextComponent component : text) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAllTexts(Iterable<ITextComponent> text) {
        for (ITextComponent component : text) {
            this.add(component);
        }
        return this;
    }

    default public void queue() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> REIRuntime.getInstance().queueTooltip(this));
    }

    public EntryStack<?> getContextStack();

    public Tooltip withContextStack(EntryStack<?> var1);
}

