/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface TransferHandler
extends Comparable<TransferHandler> {
    default public double getPriority() {
        return 0.0;
    }

    public Result handle(Context var1);

    @Override
    default public int compareTo(TransferHandler o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public TransferHandlerErrorRenderer provideErrorRenderer(Context context, Object data) {
        if (data instanceof IntList) {
            return TransferHandlerErrorRenderer.forRedSlots((IntList)data);
        }
        return null;
    }

    @ApiStatus.Internal
    public static final class ContextImpl
    implements Context {
        private boolean actuallyCrafting;
        private ContainerScreen<?> containerScreen;
        private Supplier<Display> recipeDisplaySupplier;

        private ContextImpl(boolean actuallyCrafting, ContainerScreen<?> containerScreen, Supplier<Display> recipeDisplaySupplier) {
            this.actuallyCrafting = actuallyCrafting;
            this.containerScreen = containerScreen;
            this.recipeDisplaySupplier = recipeDisplaySupplier;
        }

        @Override
        public boolean isActuallyCrafting() {
            return this.actuallyCrafting;
        }

        @Override
        public ContainerScreen<?> getContainerScreen() {
            return this.containerScreen;
        }

        @Override
        public Display getDisplay() {
            return this.recipeDisplaySupplier.get();
        }
    }

    @ApiStatus.Internal
    public static final class ResultImpl
    implements Result {
        private boolean successful;
        private boolean applicable;
        private boolean returningToScreen;
        private boolean blocking;
        private ITextComponent error;
        private Object errorRenderer;
        private int color;

        private ResultImpl() {
            this(true, true);
        }

        public ResultImpl(boolean applicable) {
            this(false, applicable);
        }

        public ResultImpl(boolean successful, boolean applicable) {
            this.successful = successful;
            this.applicable = applicable;
        }

        public ResultImpl(ITextComponent error, int color) {
            this.successful = false;
            this.applicable = true;
            this.error = error;
            this.color = color;
        }

        @Override
        public Result blocksFurtherHandling(boolean returningToScreen) {
            this.blocking = true;
            this.returningToScreen = returningToScreen;
            return this;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public Result color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public Result errorRenderer(Object data) {
            this.errorRenderer = data;
            return this;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public boolean isBlocking() {
            return this.successful || this.blocking;
        }

        @Override
        public boolean isApplicable() {
            return this.applicable;
        }

        @Override
        public boolean isReturningToScreen() {
            return this.returningToScreen;
        }

        @Override
        public ITextComponent getError() {
            return this.error;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TransferHandlerErrorRenderer getErrorRenderer(TransferHandler handler, Context context) {
            if (this.errorRenderer == null) {
                return null;
            }
            return handler.provideErrorRenderer(context, this.errorRenderer);
        }

        @Override
        public void fillTooltip(List<ITextComponent> components) {
            if (!this.isSuccessful() && this.isApplicable()) {
                components.add(this.getError());
            }
        }
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public static Context create(boolean actuallyCrafting, @Nullable ContainerScreen<?> containerScreen, Display display) {
            return new ContextImpl(actuallyCrafting, containerScreen, () -> display);
        }

        default public Minecraft getMinecraft() {
            return Minecraft.func_71410_x();
        }

        public boolean isActuallyCrafting();

        public Display getDisplay();

        @Nullable
        public ContainerScreen<?> getContainerScreen();

        @Nullable
        default public Container getMenu() {
            return this.getContainerScreen() == null ? null : this.getContainerScreen().func_212873_a_();
        }
    }

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result createSuccessful() {
            return new ResultImpl().color(0);
        }

        public static Result createNotApplicable() {
            return new ResultImpl(false).color(0);
        }

        public static Result createFailed(ITextComponent error) {
            return new ResultImpl(error, 1744764928);
        }

        public static Result createFailedCustomButtonColor(ITextComponent error, int color) {
            return Result.createFailed(error).color(color);
        }

        public static Result createFailed(ITextComponent error, IntList redSlots) {
            return Result.createFailed(error).errorRenderer(redSlots);
        }

        public static Result createFailedCustomButtonColor(ITextComponent error, IntList redSlots, int color) {
            return Result.createFailed(error).errorRenderer(redSlots).color(color);
        }

        default public Result blocksFurtherHandling() {
            return this.blocksFurtherHandling(true);
        }

        public Result blocksFurtherHandling(boolean var1);

        public int getColor();

        public Result color(int var1);

        public Result errorRenderer(Object var1);

        public boolean isSuccessful();

        public boolean isBlocking();

        public boolean isReturningToScreen();

        public boolean isApplicable();

        public ITextComponent getError();

        @OnlyIn(value=Dist.CLIENT)
        @ApiStatus.Internal
        public TransferHandlerErrorRenderer getErrorRenderer(TransferHandler var1, Context var2);

        @ApiStatus.Internal
        public void fillTooltip(List<ITextComponent> var1);
    }
}

