/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.RecipeFinderPopulator;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.transfer.info.clean.InputCleanHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public interface MenuInfo<T extends Container, D extends Display>
extends MenuInfoProvider<T, D> {
    @Override
    default public Optional<MenuInfo<T, D>> provide(CategoryIdentifier<D> categoryId, Class<T> menuClass) {
        return Optional.of(this);
    }

    public RecipeFinderPopulator<T, D> getRecipeFinderPopulator();

    public InputCleanHandler<T, D> getInputCleanHandler();

    public Iterable<SlotAccessor> getInputSlots(MenuInfoContext<T, ?, D> var1);

    public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, D> var1);

    default public void markDirty(MenuInfoContext<T, ? extends ServerPlayerEntity, D> context) {
        ((ServerPlayerEntity)context.getPlayerEntity()).field_71071_by.func_70296_d();
        context.getMenu().func_75142_b();
        Container containerMenu = ((ServerPlayerEntity)context.getPlayerEntity()).field_71070_bA;
        ((ServerPlayerEntity)context.getPlayerEntity()).func_71110_a(containerMenu, containerMenu.func_75138_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void validate(MenuInfoContext<T, ?, D> context) throws MenuTransferException {
    }

    default public List<List<ItemStack>> getInputs(MenuInfoContext<T, ?, D> context, boolean fill) {
        if (context.getDisplay() == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(context.getDisplay().getInputEntries(context, this, fill), inputEntry -> CollectionUtils.filterAndMap(inputEntry, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public List<List<ItemStack>> getInputs(MenuInfoContext<T, ?, D> context) {
        return this.getInputs(context, false);
    }

    default public CompoundNBT save(MenuSerializationContext<T, ?, D> context, D display) {
        return DisplaySerializerRegistry.getInstance().save(display, new CompoundNBT());
    }

    default public D read(MenuSerializationContext<T, ?, D> context, CompoundNBT tag) {
        return DisplaySerializerRegistry.getInstance().read(context.getCategoryIdentifier(), tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderMissingInput(MenuInfoContext<T, ?, D> context, List<List<ItemStack>> inputs, IntList missingIndices, MatrixStack matrices, int mouseX, int mouseY, float delta, List<Widget> widgets, Rectangle bounds) {
        int i = 0;
        for (Widget widget : widgets) {
            if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missingIndices.contains(i++)) continue;
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 400.0);
            Rectangle innerBounds = ((Slot)widget).getInnerBounds();
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)0x40FF0000);
            matrices.func_227865_b_();
        }
    }
}

