/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info;

import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationProviderContext;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface MenuInfoProvider<T extends Container, D extends Display> {
    @OnlyIn(value=Dist.CLIENT)
    default public Optional<MenuInfo<T, D>> provideClient(D display, T menu) {
        return this.provide(display.getCategoryIdentifier(), menu.getClass());
    }

    default public Optional<MenuInfo<T, D>> provide(CategoryIdentifier<D> display, T menu, final MenuSerializationProviderContext<T, ?, D> context, CompoundNBT networkTag) {
        final Optional<MenuInfo<T, D>> menuInfo = this.provide(display, menu.getClass());
        if (menuInfo.isPresent()) {
            menuInfo.get().read(new MenuSerializationContext<T, PlayerEntity, D>(){

                @Override
                public MenuInfo<T, D> getContainerInfo() {
                    return (MenuInfo)menuInfo.get();
                }

                @Override
                public T getMenu() {
                    return context.getMenu();
                }

                @Override
                public PlayerEntity getPlayerEntity() {
                    return context.getPlayerEntity();
                }

                @Override
                public CategoryIdentifier<D> getCategoryIdentifier() {
                    return context.getCategoryIdentifier();
                }
            }, networkTag);
        }
        return menuInfo;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public Optional<MenuInfo<T, D>> provide(CategoryIdentifier<D> var1, Class<T> var2);
}

