/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class REIRuntimeImpl
implements REIRuntime {
    private static final ResourceLocation DISPLAY_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/display.png");
    private static final ResourceLocation DISPLAY_TEXTURE_DARK = new ResourceLocation("roughlyenoughitems", "textures/gui/display_dark.png");
    @ApiStatus.Internal
    public static boolean isWithinRecipeViewingScreen = false;
    private ScreenOverlayImpl overlay;
    private OverlaySearchField searchField;
    private ContainerScreen<?> previousContainerScreen = null;
    private Screen previousScreen = null;
    private LinkedHashSet<DisplayScreen> lastDisplayScreen = Sets.newLinkedHashSetWithExpectedSize((int)10);
    private List<HintProvider> hintProviders = new ArrayList<HintProvider>();

    @ApiStatus.Internal
    public static REIRuntimeImpl getInstance() {
        return (REIRuntimeImpl)REIRuntime.getInstance();
    }

    public void addHintProvider(HintProvider provider) {
        this.hintProviders.add(provider);
    }

    public List<HintProvider> getHintProviders() {
        return Collections.unmodifiableList(this.hintProviders);
    }

    @Override
    public void queueTooltip(@Nullable Tooltip tooltip) {
        if (this.overlay != null && tooltip != null) {
            this.overlay.addTooltip(tooltip);
        }
    }

    @Override
    @Nullable
    public TextField getSearchTextField() {
        if (this.searchField == null) {
            this.searchField = new OverlaySearchField(0, 0, 0, 0);
        }
        return this.searchField;
    }

    @Nullable
    public static OverlaySearchField getSearchField() {
        return (OverlaySearchField)REIRuntimeImpl.getInstance().getSearchTextField();
    }

    public void storeDisplayScreen(DisplayScreen screen) {
        while (this.lastDisplayScreen.size() >= 10) {
            this.lastDisplayScreen.remove(Iterables.get(this.lastDisplayScreen, (int)0));
        }
        this.lastDisplayScreen.add(screen);
    }

    public boolean hasLastDisplayScreen() {
        return !this.lastDisplayScreen.isEmpty();
    }

    public Screen getLastDisplayScreen() {
        DisplayScreen screen = (DisplayScreen)Iterables.getLast(this.lastDisplayScreen);
        this.lastDisplayScreen.remove(screen);
        screen.recalculateCategoryPage();
        return (Screen)screen;
    }

    @Override
    public boolean isOverlayVisible() {
        return ConfigObject.getInstance().isOverlayVisible();
    }

    @Override
    public void toggleOverlayVisible() {
        ConfigObject.getInstance().setOverlayVisible(!ConfigObject.getInstance().isOverlayVisible());
        ConfigManager.getInstance().saveConfig();
    }

    @Override
    public Optional<ScreenOverlay> getOverlay(boolean reset, boolean init) {
        if (this.overlay == null && init || reset) {
            this.overlay = new ScreenOverlayImpl();
            this.overlay.init();
            REIRuntimeImpl.getSearchField().setFocused(false);
        }
        return Optional.ofNullable(this.overlay);
    }

    @Override
    @Nullable
    public ContainerScreen<?> getPreviousContainerScreen() {
        return this.previousContainerScreen;
    }

    @Override
    @Nullable
    public Screen getPreviousScreen() {
        return this.previousScreen;
    }

    public void setPreviousScreen(Screen previousScreen) {
        if (previousScreen == null || previousScreen.getClass().getName().contains(".rei.")) {
            return;
        }
        this.previousScreen = previousScreen;
        if (previousScreen instanceof ContainerScreen) {
            this.previousContainerScreen = (ContainerScreen)previousScreen;
        }
    }

    @Override
    public boolean isDarkThemeEnabled() {
        return ConfigObject.getInstance().isUsingDarkTheme();
    }

    @Override
    public ResourceLocation getDefaultDisplayTexture() {
        return this.isDarkThemeEnabled() ? DISPLAY_TEXTURE_DARK : DISPLAY_TEXTURE;
    }

    @Override
    public SearchFieldLocation getContextualSearchFieldLocation() {
        SearchFieldLocation location = ConfigObject.getInstance().getSearchFieldLocation();
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(Minecraft.func_71410_x().field_71462_r);
        if (location == SearchFieldLocation.CENTER && window.func_198087_p() - 20 <= screenBounds.getMaxY()) {
            return SearchFieldLocation.BOTTOM_SIDE;
        }
        return location;
    }

    @Override
    public Rectangle calculateEntryListArea(Rectangle bounds) {
        SearchFieldLocation searchFieldLocation = this.getContextualSearchFieldLocation();
        int yOffset = 2;
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE) {
            yOffset += 24;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            yOffset += 22;
        }
        int heightOffset = 0;
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE) {
            heightOffset += 24;
        }
        return new Rectangle(bounds.x, bounds.y + yOffset, bounds.width, bounds.height - 1 - yOffset - heightOffset);
    }

    @Override
    public Rectangle calculateFavoritesListArea() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation().mirror(), Minecraft.func_71410_x().field_71462_r);
        int yOffset = 8;
        if (!ConfigObject.getInstance().isLowerConfigButton()) {
            yOffset += 25;
        }
        bounds = new Rectangle(bounds.x, bounds.y + yOffset, bounds.width, bounds.height - 3 - yOffset);
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getFavoritesHorizontalEntriesBoundariesPercentage()));
        if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.LEFT) {
            bounds.x += widthReduction;
        }
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getFavoritesHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75) + 8;
        if (bounds.width > maxWidth) {
            if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.LEFT) {
                bounds.x += bounds.width - maxWidth;
            }
            bounds.width = maxWidth;
        }
        return bounds;
    }

    @Override
    public void startReload() {
        Argument.SEARCH_CACHE.clear();
        this.getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
        this.lastDisplayScreen.clear();
    }

    @Override
    public void startReload(ReloadStage stage) {
        this.startReload();
    }

    @Override
    public void endReload(ReloadStage stage) {
        Argument.SEARCH_CACHE.clear();
        this.getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
    }

    public void onInitializeClient() {
        GuiEvent.INIT_PRE.register((screen, widgets, children) -> {
            if (this.previousContainerScreen != screen && screen instanceof ContainerScreen) {
                this.previousContainerScreen = (ContainerScreen)screen;
            }
            return ActionResultType.PASS;
        });
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (this.isOverlayVisible() && REIRuntime.getInstance().getOverlay().isPresent()) {
                ScreenOverlayImpl.getInstance().tick();
            }
        });
    }
}

