/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubSubsetsMenuEntry
extends MenuEntry {
    public final String text;
    private int textWidth = -69;
    private int x;
    private int y;
    private int width;
    private boolean selected;
    private boolean containsMouse;
    private boolean rendering;
    private List<MenuEntry> entries;
    private Menu subsetsMenu;
    private Tuple<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1L;
    private boolean clickedBefore = false;

    public SubSubsetsMenuEntry(String text) {
        this(text, Collections.emptyList());
    }

    public SubSubsetsMenuEntry(String text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubSubsetsMenuEntry(String text, List<MenuEntry> entries) {
        this.text = text;
        this.entries = entries;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.func_78256_a(this.text));
        }
        return this.textWidth;
    }

    public Menu getSubsetsMenu() {
        if (this.subsetsMenu == null) {
            this.subsetsMenu = new Menu(new Point(this.getParent().getBounds().getMaxX() - 1, this.y - 1), this.entries);
        }
        return this.subsetsMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        double filteredRatio = this.getFilteredRatio();
        if (filteredRatio > 0.0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            SubSubsetsMenuEntry.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)((0xFF0000 | MathHelper.func_76143_f((double)(filteredRatio * 255.0)) << 24) + (this.selected ? 39321 : 0)));
        } else if (this.selected) {
            SubSubsetsMenuEntry.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
        }
        if (this.selected) {
            if (!this.entries.isEmpty()) {
                Menu menu = this.getSubsetsMenu();
                menu.menuStartPoint.x = this.getParent().getBounds().getMaxX() - 1;
                menu.menuStartPoint.y = this.y - 1;
                ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                menu.func_230430_a_(matrices, mouseX, mouseY, delta);
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            } else {
                this.clickedBefore = false;
            }
            if (this.clickedBefore) {
                if (this.rendering && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + 12 && !this.entries.isEmpty()) {
                    REIRuntime.getInstance().queueTooltip(Tooltip.create(new ITextComponent[]{new StringTextComponent("Click again to filter everything in this group.")}));
                } else {
                    this.clickedBefore = false;
                }
            }
        } else {
            this.clickedBefore = false;
        }
        this.font.func_238421_b_(matrices, this.text, (float)(this.x + 2), (float)(this.y + 2), this.selected ? 0xFFFFFF : 0x888888);
        if (!this.entries.isEmpty()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TabWidget.CHEST_GUI_TEXTURE);
            this.func_238474_b_(matrices, this.x + this.width - 15, this.y - 2, 0, 28, 18, 18);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12) && !this.entries.isEmpty()) {
            if (this.clickedBefore) {
                this.clickedBefore = false;
                List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
                Menu overlay = ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).getOverlayMenu();
                this.setFiltered(filteredStacks, overlay, this, !(this.getFilteredRatio() > 0.0));
                ConfigManager.getInstance().saveConfig();
                EntryRegistry.getInstance().refilter();
                if (REIRuntimeImpl.getSearchField() != null) {
                    ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
                }
            } else {
                this.clickedBefore = true;
            }
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFiltered(List<EntryStackProvider<?>> filteredStacks, Menu subsetsMenu, SubSubsetsMenuEntry subSubsetsMenuEntry, boolean filtered) {
        for (MenuEntry entry : subSubsetsMenuEntry.entries) {
            if (entry instanceof EntryStackSubsetsMenuEntry) {
                EntryStackSubsetsMenuEntry menuEntry = (EntryStackSubsetsMenuEntry)entry;
                if (menuEntry.isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> EntryStacks.equalsExact(next.provide(), menuEntry.stack));
                    } else {
                        filteredStacks.add(EntryStackProvider.ofStack(menuEntry.stack.normalize()));
                    }
                }
                if (subsetsMenu == null) continue;
                menuEntry.recalculateFilter(subsetsMenu);
                continue;
            }
            if (!(entry instanceof SubSubsetsMenuEntry)) continue;
            this.setFiltered(filteredStacks, subsetsMenu, (SubSubsetsMenuEntry)entry, filtered);
        }
    }

    public double getFilteredRatio() {
        Tuple<Integer, Integer> pair = this.getFilteredRatioPair();
        return (Integer)pair.func_76340_b() == 0 ? 0.0 : (double)((Integer)pair.func_76341_a()).intValue() / (double)((Integer)pair.func_76340_b()).intValue();
    }

    public Tuple<Integer, Integer> getFilteredRatioPair() {
        List<EntryStackProvider<?>> filteredStacks = ConfigObject.getInstance().getFilteredStackProviders();
        if (this.lastListHash != (long)filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (MenuEntry entry : this.entries) {
                if (entry instanceof EntryStackSubsetsMenuEntry) {
                    ++size;
                    if (!((EntryStackSubsetsMenuEntry)entry).isFiltered()) continue;
                    ++filtered;
                    continue;
                }
                if (!(entry instanceof SubSubsetsMenuEntry)) continue;
                Tuple<Integer, Integer> pair = ((SubSubsetsMenuEntry)entry).getFilteredRatioPair();
                filtered += ((Integer)pair.func_76341_a()).intValue();
                size += ((Integer)pair.func_76340_b()).intValue();
            }
            this.filteredRatio = new Tuple((Object)filtered, (Object)size);
            this.lastListHash = filteredStacks.hashCode();
        }
        return this.filteredRatio;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.subsetsMenu != null && !this.subsetsMenu.func_231039_at__().isEmpty() && this.selected) {
            return this.subsetsMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.subsetsMenu != null && !this.subsetsMenu.func_231039_at__().isEmpty() && this.selected && this.subsetsMenu.func_231043_a_(mouseX, mouseY, amount);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        if (this.subsetsMenu != null && !this.subsetsMenu.func_231039_at__().isEmpty() && this.selected) {
            return Collections.singletonList(this.subsetsMenu);
        }
        return Collections.emptyList();
    }
}

