/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.impl.client.gui.performance.entry.EntryListEntry;
import me.shedaniel.rei.impl.client.gui.performance.entry.SubCategoryListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PerformanceScreen
extends Screen {
    private Screen parent;
    private PerformanceEntryListWidget list;

    public PerformanceScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("text.rei.performance"));
        this.parent = parent;
    }

    public static IReorderingProcessor formatTime(long time, boolean total) {
        TimeUnit unit = PerformanceScreen.chooseUnit(time);
        double value = (double)time / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return new StringTextComponent(String.format(Locale.ROOT, "%.4g", value) + " " + PerformanceScreen.abbreviate(unit)).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)PerformanceScreen.chooseColor(TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), total)))).func_241878_f();
    }

    private static int chooseColor(long time, boolean total) {
        if (time > (long)(total ? 2500 : 1000)) {
            return 0xFF5555;
        }
        if (time > (long)(total ? 700 : 300)) {
            return 16754176;
        }
        if (time > (long)(total ? 200 : 100)) {
            return 16773143;
        }
        return 0x12FF22;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    public void func_231160_c_() {
        IFormattableTextComponent backText = new StringTextComponent("\u21a9 ").func_230529_a_((ITextComponent)new TranslationTextComponent("gui.back"));
        this.func_230480_a_((Widget)new Button(4, 4, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)backText) + 10, 20, (ITextComponent)backText, button -> {
            this.field_230706_i_.func_147108_a(this.parent);
            this.parent = null;
        }));
        this.list = new PerformanceEntryListWidget();
        RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.getStages().forEach((stage, inner) -> {
            long separateTime;
            ArrayList<PerformanceEntry> entries = new ArrayList<PerformanceEntry>();
            inner.times().forEach((obj, time) -> entries.add(new EntryListEntry((ITextComponent)new StringTextComponent(obj instanceof Pair ? ((REIPluginProvider)((Pair)obj).getFirst()).getPluginProviderName() : Objects.toString(obj)), (long)time)));
            Collection<Long> values = inner.times().values();
            Map<Object, Long> map = inner.times();
            synchronized (map) {
                separateTime = values.stream().collect(Collectors.summarizingLong(value -> value)).getSum();
            }
            if (inner.totalNano() - separateTime > 1000000L) {
                entries.add(new EntryListEntry((ITextComponent)new StringTextComponent("Miscellaneous Operations"), inner.totalNano() - separateTime));
            }
            entries.sort(Comparator.comparingLong(value -> value.time).reversed());
            this.list.addItem(new SubCategoryListEntry((ITextComponent)new StringTextComponent(stage), entries, inner.totalNano(), false));
        });
        this.func_230481_d_((IGuiEventListener)this.list);
    }

    public void func_230430_a_(MatrixStack poses, int mouseX, int mouseY, float delta) {
        this.func_231165_f_(0);
        this.list.func_230430_a_(poses, mouseX, mouseY, delta);
        this.field_230712_o_.func_238407_a_(poses, this.field_230704_d_.func_241878_f(), (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f, 12.0f, -1);
        super.func_230430_a_(poses, mouseX, mouseY, delta);
    }

    private class PerformanceEntryListWidget
    extends DynamicElementListWidget<PerformanceEntry> {
        public PerformanceEntryListWidget() {
            super(PerformanceScreen.this.field_230706_i_, PerformanceScreen.this.field_230708_k_, PerformanceScreen.this.field_230709_l_, 30, PerformanceScreen.this.field_230709_l_, AbstractGui.field_230663_f_);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(PerformanceEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static abstract class PerformanceEntry
    extends DynamicElementListWidget.ElementEntry<PerformanceEntry> {
    }
}

