/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.gui.animator.NumberAnimator;
import me.shedaniel.rei.api.client.gui.animator.ValueAnimator;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.screen.ConfigReloadingScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UncertainDisplayViewingScreen
extends Screen {
    private static final ResourceLocation DEFAULT = new ResourceLocation("roughlyenoughitems", "textures/gui/screenshot_default.png");
    private static final ResourceLocation COMPOSITE = new ResourceLocation("roughlyenoughitems", "textures/gui/screenshot_composite.png");
    private final List<Widget> widgets;
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0.0;
    private double target = 0.0;
    private BooleanConsumer callback;
    private Button button;
    private Screen parent;
    private Widget slider;
    private boolean showTips;
    public NumberAnimator<Double> scroll = ValueAnimator.ofDouble();
    private List<String> allModsUsingJEI = null;
    private boolean jeiEnabled = false;

    public UncertainDisplayViewingScreen(Screen parent, DisplayScreenType type, boolean showTips, BooleanConsumer callback) {
        super((ITextComponent)ImmutableTextComponent.EMPTY);
        this.widgets = Lists.newArrayList();
        if (type == DisplayScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == DisplayScreenType.ORIGINAL;
            this.moveFrameTo(this.original ? 0.0 : 1.0, false, 0L);
        }
        this.scroll.setAs(0);
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
        if (showTips) {
            // empty if block
        }
    }

    public final double clamp(double v) {
        return this.clamp(v, 30.0);
    }

    public final double clamp(double v, double clampExtension) {
        return MathHelper.func_151237_a((double)v, (double)(-clampExtension), (double)(1.0 + clampExtension));
    }

    private void moveFrameTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.frame = this.target;
        }
    }

    public void func_231160_c_() {
        this.func_231039_at__().clear();
        this.widgets.clear();
        this.button = Widgets.createButton(new Rectangle(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 40, 200, 20), NarratorChatListener.field_216868_a).onRender((matrices, button) -> {
            button.setEnabled(this.isSet);
            if ((Double)this.scroll.target() != 0.0 && this.allModsUsingJEI != null) {
                button.setText((ITextComponent)new TranslationTextComponent("gui.done"));
            } else {
                button.setText((ITextComponent)(this.isSet ? new TranslationTextComponent("text.rei.select") : new TranslationTextComponent("config.roughlyenoughitems.recipeScreenType.unset")));
            }
        }).onClick(button -> {
            if ((Double)this.scroll.target() == 0.0 && this.allModsUsingJEI != null) {
                this.scroll.setTo(200, 450L);
            } else if (this.allModsUsingJEI != null && this.jeiEnabled) {
                ConfigManagerImpl.getInstance().getConfig().setJEICompatibilityLayerEnabled(this.jeiEnabled);
                ConfigManager.getInstance().saveConfig();
                RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.clear();
                RoughlyEnoughItemsCoreClient.reloadPlugins(null, null);
                Minecraft.func_71410_x().func_147108_a((Screen)new ConfigReloadingScreen(() -> this.callback.accept(this.original)));
            } else {
                this.callback.accept(this.original);
            }
        });
        this._children().add((IGuiEventListener)this.button);
        this.widgets.add(this.transformScroll(new ScreenTypeSelection(this.field_230708_k_ / 2 - 200 - 5, this.field_230709_l_ / 2 - 56 - 10, DisplayScreenType.ORIGINAL)));
        this.widgets.add(this.transformScroll(Widgets.createLabel(new Point(this.field_230708_k_ / 2 - 200 - 5 + 104, this.field_230709_l_ / 2 - 56 + 115), (ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.recipeScreenType.original")).noShadow().color(-1124073473)));
        this.widgets.add(this.transformScroll(new ScreenTypeSelection(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 2 - 56 - 10, DisplayScreenType.COMPOSITE)));
        this.widgets.add(this.transformScroll(Widgets.createLabel(new Point(this.field_230708_k_ / 2 + 5 + 104, this.field_230709_l_ / 2 - 56 + 115), (ITextComponent)new TranslationTextComponent("config.roughlyenoughitems.recipeScreenType.composite")).noShadow().color(-1124073473)));
        this.slider = this.transformScroll(Widgets.wrapVanillaWidget((IGuiEventListener)new AbstractSlider(this.field_230708_k_ / 2 - 100, this.field_230709_l_ * 2 - 64, 200, 20, (ITextComponent)new TranslationTextComponent("text.rei.jei_compat.false"), 0.0){

            protected void func_230979_b_() {
                this.func_238482_a_((ITextComponent)new TranslationTextComponent("text.rei.jei_compat." + (UncertainDisplayViewingScreen.this.jeiEnabled = this.field_230683_b_ == 1.0)));
            }

            protected void func_230972_a_() {
            }

            public void func_230431_b_(MatrixStack poseStack, int i, int j, float f) {
                this.field_230691_m_ = UncertainDisplayViewingScreen.this.field_230709_l_ * 2 - 64;
                super.func_230431_b_(poseStack, i, j, f);
                this.field_230691_m_ = UncertainDisplayViewingScreen.this.field_230709_l_ * 2 - 64 - (int)(UncertainDisplayViewingScreen.this.scroll.floatValue() / 200.0f * (float)this.field_230689_k_);
            }
        }));
        this.widgets.add(this.slider);
        this._children().addAll(this.widgets);
    }

    public List<IGuiEventListener> _children() {
        return this.func_231039_at__();
    }

    private Widget transformScroll(Widget widget) {
        return Widgets.withTranslate(widget, () -> Matrix4f.func_226599_b_((float)0.0f, (float)(-(this.scroll.floatValue() / 200.0f * (float)this.field_230709_l_)), (float)0.0f));
    }

    public void func_230430_a_(MatrixStack matrices, int int_1, int int_2, float float_1) {
        this.scroll.update(float_1);
        if (this.field_230706_i_.field_71441_e != null) {
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -16777216, -16777216);
        }
        if ((Double)this.scroll.target() == 0.0) {
            UncertainDisplayViewingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("text.rei.recipe_screen_type.selection"), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        } else {
            UncertainDisplayViewingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("text.rei.jei_compat"), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        }
        Objects.requireNonNull(this.field_230712_o_);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 20 + 9 + 2, this.field_230708_k_, this.field_230709_l_ - 42));
        if (this.showTips) {
            float i = 32.0f - this.scroll.floatValue() / 200.0f * (float)this.field_230709_l_;
            for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("text.rei.recipe_screen_type.selection.sub").func_240699_a_(TextFormatting.GRAY), this.field_230708_k_ - 30)) {
                this.field_230712_o_.func_238407_a_(matrices, s, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(s) / 2), i, -1);
                i += 10.0f;
            }
            if (this.allModsUsingJEI != null) {
                i = (float)(32 + this.field_230709_l_) - this.scroll.floatValue() / 200.0f * (float)this.field_230709_l_;
                for (IReorderingProcessor s : this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("text.rei.jei_compat.sub", new Object[]{new TranslationTextComponent("text.rei.jei_compat.sub.stability"), new StringTextComponent(String.join((CharSequence)", ", this.allModsUsingJEI))}).func_240699_a_(TextFormatting.GRAY), this.field_230708_k_ - 30)) {
                    this.field_230712_o_.func_238407_a_(matrices, s, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(s) / 2), i, -1);
                    i += 10.0f;
                }
            }
        }
        super.func_230430_a_(matrices, int_1, int_2, float_1);
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(matrices, int_1, int_2, float_1);
        }
        if (this.isSet) {
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, (double)(-(this.scroll.floatValue() / 200.0f * (float)this.field_230709_l_)), 0.0);
            this.updateFramePosition(float_1);
            int x = (int)((double)(this.field_230708_k_ / 2 - 205) + 210.0 * this.frame);
            int y = this.field_230709_l_ / 2 - 56 - 10;
            this.func_238468_a_(matrices, x - 2, y - 4, x - 6 + 208, y - 4 + 2, -1778384897, -1778384897);
            this.func_238468_a_(matrices, x - 2, y - 4 + 126 - 2, x - 6 + 208, y - 4 + 126, -1778384897, -1778384897);
            this.func_238468_a_(matrices, x - 4, y - 4, x - 4 + 2, y - 4 + 126, -1778384897, -1778384897);
            this.func_238468_a_(matrices, x - 4 + 208 - 2, y - 4, x - 4 + 208, y - 4 + 126, -1778384897, -1778384897);
            matrices.func_227865_b_();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.button.func_230430_a_(matrices, int_1, int_2, float_1);
    }

    private void updateFramePosition(float delta) {
        this.target = this.clamp(this.target);
        this.frame = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.frame, (double)this.target, (double)0.001f) ? this.ease(this.frame, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration * (double)delta * 3.0, 1.0)) : this.target;
    }

    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (int_1 == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(int_1, int_2)) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
            if (this.parent instanceof ContainerScreen) {
                REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
            }
            return true;
        }
        return super.func_231046_a_(int_1, int_2, int_3);
    }

    public boolean func_231045_a_(double d, double e, int i, double f, double g) {
        return this.slider.func_231045_a_(d, e, i, f, g) || super.func_231045_a_(d, e, i, f, g);
    }

    public class ScreenTypeSelection
    extends WidgetWithBounds {
        private final DisplayScreenType type;
        private Rectangle bounds;

        public ScreenTypeSelection(int x, int y, DisplayScreenType type) {
            this.type = type;
            this.bounds = new Rectangle(x - 4 + 16, y - 4, 184, 128);
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void func_230430_a_(MatrixStack matrices, int i, int i1, float delta) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.type == DisplayScreenType.ORIGINAL ? DEFAULT : COMPOSITE);
            ScreenTypeSelection.func_238466_a_((MatrixStack)matrices, (int)(this.bounds.x + (this.type == DisplayScreenType.ORIGINAL ? 8 : 4)), (int)(this.bounds.y + 4), (int)(this.bounds.width - 8), (int)(this.bounds.height - 8), (float)113.0f, (float)(this.type == DisplayScreenType.ORIGINAL ? 16.0f : 27.0f), (int)628, (int)426, (int)854, (int)480);
        }

        public boolean func_231044_a_(double double_1, double double_2, int int_1) {
            if (this.containsMouse(double_1, double_2)) {
                UncertainDisplayViewingScreen.this.original = this.type == DisplayScreenType.ORIGINAL;
                if (!UncertainDisplayViewingScreen.this.isSet) {
                    UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, false, 0L);
                }
                UncertainDisplayViewingScreen.this.isSet = true;
                UncertainDisplayViewingScreen.this.moveFrameTo(UncertainDisplayViewingScreen.this.original ? 0.0 : 1.0, true, 500L);
                return true;
            }
            return false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }
}

