/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public abstract class EntryListEntryWidget
extends EntryWidget {
    public int backupY;

    protected EntryListEntryWidget(Point point, int entrySize) {
        super(point);
        this.backupY = point.y;
        this.getBounds().width = this.getBounds().height = entrySize;
    }

    @Override
    protected void drawHighlighted(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.getCurrentEntry().isEmpty()) {
            super.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    public void queueTooltip(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (ClientHelper.getInstance().isCheating() && !(Minecraft.func_71410_x().field_71462_r instanceof DisplayScreen) && !this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        super.queueTooltip(matrices, mouseX, mouseY, delta);
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return super.func_231048_c_(mouseX, mouseY, button);
        }
        if (this.containsMouse(mouseX, mouseY) && this.wasClicked()) {
            if (this.doAction(mouseX, mouseY, button)) {
                return true;
            }
            this.wasClicked = true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected boolean doAction(double mouseX, double mouseY, int button) {
        if (!ClientHelper.getInstance().isCheating() || Minecraft.func_71410_x().field_71462_r instanceof DisplayScreen) {
            return false;
        }
        EntryStack<Object> entry = this.getCurrentEntry().copy();
        if (!entry.isEmpty()) {
            FluidStack value;
            Item bucketItem;
            if (entry.getValueType() == FluidStack.class && (bucketItem = (value = (FluidStack)entry.getValue()).getFluid().func_204524_b()) != null) {
                entry = EntryStacks.of((IItemProvider)bucketItem);
            }
            if (entry.getValueType() == ItemStack.class) {
                ((ItemStack)entry.castValue()).func_190920_e(button != 1 && !Screen.func_231173_s_() ? 1 : ((ItemStack)entry.castValue()).func_77976_d());
            }
            return ClientHelper.getInstance().tryCheatingEntry(entry);
        }
        return false;
    }

    @Override
    protected boolean cancelDeleteItems(EntryStack<?> stack) {
        EntryStack<Object> entry;
        if (!this.interactable || !ConfigObject.getInstance().isGrabbingItems()) {
            return super.cancelDeleteItems(stack);
        }
        if (ClientHelper.getInstance().isCheating() && !(Minecraft.func_71410_x().field_71462_r instanceof DisplayScreen) && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
            FluidStack value;
            Item bucketItem;
            if (entry.getValueType() == FluidStack.class && (bucketItem = (value = (FluidStack)entry.getValue()).getFluid().func_204524_b()) != null) {
                entry = EntryStacks.of((IItemProvider)bucketItem);
            }
            return EntryStacks.equalsExact(entry, stack);
        }
        return super.cancelDeleteItems(stack);
    }
}

