/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EntryWidget
extends Slot
implements DraggableStackProviderWidget {
    @ApiStatus.Internal
    public static long stackDisplayOffset = 0L;
    protected static final ResourceLocation RECIPE_GUI = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected static final ResourceLocation RECIPE_GUI_DARK = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    @ApiStatus.Internal
    private byte noticeMark = 0;
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    protected boolean wasClicked = false;
    private Rectangle bounds;
    private List<EntryStack<?>> entryStacks;
    public ResourceLocation tagMatch;
    public boolean removeTagMatch = true;

    public EntryWidget(Point point) {
        this(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public EntryWidget(Rectangle bounds) {
        this.bounds = bounds;
        this.entryStacks = Collections.emptyList();
    }

    @Override
    public EntryWidget unmarkInputOrOutput() {
        this.noticeMark = 0;
        return this;
    }

    public EntryWidget markIsInput() {
        this.noticeMark = 1;
        return this;
    }

    public EntryWidget markIsOutput() {
        this.noticeMark = (byte)2;
        return this;
    }

    @Override
    public byte getNoticeMark() {
        return this.noticeMark;
    }

    @Override
    public void setNoticeMark(byte noticeMark) {
        this.noticeMark = noticeMark;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable(interactable);
    }

    @Override
    public boolean isInteractable() {
        return this.interactable;
    }

    @Override
    public void setInteractableFavorites(boolean interactableFavorites) {
        this.interactableFavorites(interactableFavorites);
    }

    @Override
    public boolean isInteractableFavorites() {
        return this.interactableFavorites;
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    @Override
    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    @Override
    public EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.highlight;
    }

    @Override
    public void setHighlightEnabled(boolean highlights) {
        this.highlight(highlights);
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    @Override
    public void setTooltipsEnabled(boolean tooltipsEnabled) {
        this.tooltips(tooltipsEnabled);
    }

    @Override
    public boolean isTooltipsEnabled() {
        return this.tooltips;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    @Override
    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.background(backgroundEnabled);
    }

    @Override
    public boolean isBackgroundEnabled() {
        return this.background;
    }

    public EntryWidget clearStacks() {
        this.entryStacks = Collections.emptyList();
        return this;
    }

    @Override
    public Slot clearEntries() {
        return this.clearStacks();
    }

    @Override
    public EntryWidget entry(EntryStack<?> stack) {
        if (this.entryStacks.isEmpty()) {
            this.entryStacks = Collections.singletonList(stack);
        } else {
            if (!(this.entryStacks instanceof ArrayList)) {
                this.entryStacks = new ArrayList(this.entryStacks);
            }
            this.entryStacks.add(stack);
        }
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    @Override
    public EntryWidget entries(Collection<? extends EntryStack<?>> stacks) {
        if (!stacks.isEmpty()) {
            if (!(this.entryStacks instanceof ArrayList)) {
                this.entryStacks = new ArrayList(this.entryStacks);
            }
            this.entryStacks.addAll(stacks);
            if (this.removeTagMatch) {
                this.tagMatch = null;
            }
        }
        return this;
    }

    @Override
    public EntryStack<?> getCurrentEntry() {
        int size = this.entryStacks.size();
        if (size == 0) {
            return EntryStack.empty();
        }
        if (size == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(MathHelper.func_76128_c((double)((double)((System.currentTimeMillis() + stackDisplayOffset) / 1000L) % (double)size)));
    }

    @Override
    public List<EntryStack<?>> getEntries() {
        return this.entryStacks;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.drawBackground(matrices, mouseX, mouseY, delta);
        this.drawCurrentEntry(matrices, mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(matrices, mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
        this.drawExtra(matrices, mouseX, mouseY, delta);
    }

    public final boolean hasTooltips() {
        return this.isTooltipsEnabled();
    }

    public final boolean hasHighlight() {
        return this.isHighlightEnabled();
    }

    protected void drawBackground(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.background) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(REIRuntime.getInstance().isDarkThemeEnabled() ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.func_238474_b_(matrices, this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
        }
    }

    protected void drawCurrentEntry(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        EntryStack<?> entry = this.getCurrentEntry();
        entry.setZ(100);
        entry.render(matrices, this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        Tooltip tooltip = this.getCurrentTooltip(new Point(mouseX, mouseY));
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.addAllTexts(Stream.of(I18n.func_135052_a((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
                } else {
                    tooltip.addAllTexts(Stream.of(I18n.func_135052_a((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
                }
            }
            if (this.tagMatch != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("text.rei.tag_match", new Object[]{this.tagMatch.toString()}).func_240699_a_(TextFormatting.GRAY));
            }
            tooltip.queue();
        }
    }

    protected void drawExtra(MatrixStack matrices, int mouseX, int mouseY, float delta) {
    }

    @Override
    @Nullable
    public Tooltip getCurrentTooltip(Point point) {
        return this.getCurrentEntry().getTooltip(point);
    }

    protected void drawHighlighted(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = REIRuntime.getInstance().isDarkThemeEnabled() ? -1877929711 : -2130706433;
        this.setZ(300);
        Rectangle bounds = this.getInnerBounds();
        this.func_238468_a_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), color, color);
        this.setZ(0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }

    protected boolean wasClicked() {
        boolean b = this.wasClicked;
        this.wasClicked = false;
        return b;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.wasClicked = true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (REIRuntimeImpl.isWithinRecipeViewingScreen && this.entryStacks.size() > 1 && this.containsMouse(mouseX, mouseY)) {
            if (amount < 0.0) {
                stackDisplayOffset = ((System.currentTimeMillis() + stackDisplayOffset) / 1000L - 1L) * 1000L;
                return true;
            }
            if (amount > 0.0) {
                stackDisplayOffset = ((System.currentTimeMillis() + stackDisplayOffset) / 1000L + 1L) * 1000L;
                return true;
            }
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.wasClicked() && this.containsMouse(mouseX, mouseY)) {
            FavoriteEntry favoriteEntry;
            ModifierKeyCode keyCode;
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.ofMouse()) && !this.getCurrentEntry().isEmpty() && (keyCode = ConfigObject.getInstance().getFavoriteKeyCode()).matchesMouse(button) && (favoriteEntry = this.asFavoriteEntry()) != null) {
                if (this.reverseFavoritesAction()) {
                    ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                } else {
                    ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                    ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                }
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
            if (ConfigObject.getInstance().getRecipeKeybind().getType() != InputMappings.Type.MOUSE && button == 0 || ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().getType() != InputMappings.Type.MOUSE && button == 1 || ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
            }
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected FavoriteEntry asFavoriteEntry() {
        FavoriteEntry entry = FavoriteEntry.fromEntryStack(this.getCurrentEntry().normalize());
        return entry.isInvalid() ? null : entry;
    }

    @ApiStatus.Internal
    protected boolean cancelDeleteItems(EntryStack<?> stack) {
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return mouseX >= (double)(this.bounds.x + 1) && mouseY >= (double)(this.bounds.y + 1) && mouseX <= (double)(this.bounds.getMaxX() - 1) && mouseY <= (double)(this.bounds.getMaxY() - 1);
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (!this.interactable) {
            return false;
        }
        if (this.containsMouse(PointHelper.ofMouse())) {
            FavoriteEntry favoriteEntry;
            ModifierKeyCode keyCode;
            if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.ofMouse()) && !this.getCurrentEntry().isEmpty() && (keyCode = ConfigObject.getInstance().getFavoriteKeyCode()).matchesKey(int_1, int_2) && (favoriteEntry = this.asFavoriteEntry()) != null) {
                if (this.reverseFavoritesAction()) {
                    ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                } else {
                    ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                    ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                }
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(int_1, int_2)) {
                return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(int_1, int_2)) {
                return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
            }
        }
        return false;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(final DraggingContext<Screen> context, double mouseX, double mouseY) {
        if (!this.getCurrentEntry().isEmpty() && this.containsMouse(mouseX, mouseY)) {
            return new DraggableStack(){
                EntryStack<?> stack;
                {
                    this.stack = EntryWidget.this.getCurrentEntry().copy().removeSetting(EntryStack.Settings.RENDERER).removeSetting(EntryStack.Settings.FLUID_RENDER_RATIO);
                }

                @Override
                public EntryStack<?> getStack() {
                    return this.stack;
                }

                @Override
                public void drag() {
                }

                @Override
                public void release(DraggedAcceptorResult result) {
                    if (result == DraggedAcceptorResult.PASS) {
                        context.renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(EntryWidget.this.getBounds().x, EntryWidget.this.getBounds().y));
                    }
                }
            };
        }
        return null;
    }

    @Override
    @Deprecated
    public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        Rectangle clone = this.getBounds().clone();
        this.getBounds().setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
        this.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.getBounds().setBounds(clone);
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category) {
        super.fillCrashReport(report, category);
        category.func_189529_a("Notice mark", () -> String.valueOf(this.getNoticeMark()));
        category.func_189529_a("Interactable", () -> String.valueOf(this.isInteractable()));
        category.func_189529_a("Interactable favorites", () -> String.valueOf(this.isInteractableFavorites()));
        category.func_189529_a("Highlight enabled", () -> String.valueOf(this.isHighlightEnabled()));
        category.func_189529_a("Tooltip enabled", () -> String.valueOf(this.isTooltipsEnabled()));
        category.func_189529_a("Background enabled", () -> String.valueOf(this.isBackgroundEnabled()));
        category.func_189529_a("Entries count", () -> String.valueOf(this.entryStacks.size()));
        EntryStack<?> currentEntry = this.getCurrentEntry();
        CrashReportCategory entryCategory = report.func_85058_a("Current Rendering Entry");
        currentEntry.fillCrashReport(report, entryCategory);
    }
}

