/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerErrorRenderer;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, ITextComponent text, Supplier<Display> displaySupplier, Supplier<Collection<ResourceLocation>> idsSupplier, List<Widget> setupDisplay, DisplayCategory<?> category) {
        final ContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        MutableObject errorTooltip = new MutableObject(new ArrayList());
        final Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> {
            TransferHandler.Context context = TransferHandler.Context.create(true, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler autoTransferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = autoTransferHandler.handle(context);
                    if (!result.isBlocking()) continue;
                    if (!result.isReturningToScreen()) {
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Minecraft.func_71410_x().func_147108_a((Screen)containerScreen);
            REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
        }).tooltipSupplier(arg_0 -> InternalWidgets.lambda$createAutoCraftingButtonWidget$1((Mutable)errorTooltip, idsSupplier, arg_0));
        return new DelegateWidget(autoCraftingButton, (Mutable)errorTooltip, displaySupplier, setupDisplay, displayBounds){
            boolean didJustRender;
            final /* synthetic */ Mutable val$errorTooltip;
            final /* synthetic */ Supplier val$displaySupplier;
            final /* synthetic */ List val$setupDisplay;
            final /* synthetic */ Rectangle val$displayBounds;
            {
                this.val$errorTooltip = mutable;
                this.val$displaySupplier = supplier;
                this.val$setupDisplay = list;
                this.val$displayBounds = rectangle;
                super(widget);
                this.didJustRender = false;
            }

            @Override
            public void func_230430_a_(MatrixStack poses, int mouseX, int mouseY, float delta) {
                this.didJustRender = false;
                autoCraftingButton.setEnabled(false);
                autoCraftingButton.setTint(0);
                if (containerScreen == null) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("error.rei.not.supported.move.items").func_240699_a_(TextFormatting.RED)}));
                    this.renderIf(false, poses, mouseX, mouseY, delta);
                    return;
                }
                ArrayList<TransferHandler.Result> errors = new ArrayList<TransferHandler.Result>();
                boolean hasApplicable = false;
                TransferHandlerErrorRenderer errorRenderer = null;
                TransferHandler.Context context = TransferHandler.Context.create(false, containerScreen, (Display)this.val$displaySupplier.get());
                for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
                    try {
                        TransferHandler.Result result = transferHandler.handle(context);
                        if (!result.isApplicable()) continue;
                        hasApplicable = true;
                        autoCraftingButton.setTint(result.getColor());
                        if (result.isSuccessful()) {
                            errors.clear();
                            autoCraftingButton.setEnabled(true);
                            errorRenderer = null;
                            break;
                        }
                        errors.add(result);
                        TransferHandlerErrorRenderer transferHandlerErrorRenderer = result.getErrorRenderer(transferHandler, context);
                        if (transferHandlerErrorRenderer != null) {
                            errorRenderer = transferHandlerErrorRenderer;
                        }
                        if (!result.isBlocking()) continue;
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (!hasApplicable) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("error.rei.not.supported.move.items").func_240699_a_(TextFormatting.RED)}));
                    this.renderIf(false, poses, mouseX, mouseY, delta);
                    return;
                }
                if ((this.containsMouse(mouseX, mouseY) || autoCraftingButton.isFocused()) && errorRenderer != null) {
                    errorRenderer.render(poses, mouseX, mouseY, delta, this.val$setupDisplay, this.val$displayBounds, (Display)this.val$displaySupplier.get());
                }
                if (errors.isEmpty()) {
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("text.auto_craft.move_items")}));
                } else {
                    IFormattableTextComponent colored;
                    this.val$errorTooltip.setValue((Object)Lists.newArrayList());
                    ArrayList<ITextComponent> tooltipsFilled = new ArrayList<ITextComponent>();
                    for (TransferHandler.Result error : errors) {
                        error.fillTooltip(tooltipsFilled);
                    }
                    if (errors.size() == 1) {
                        for (ITextComponent tooltipFilled : tooltipsFilled) {
                            colored = tooltipFilled.func_230532_e_().func_240699_a_(TextFormatting.RED);
                            if (CollectionUtils.anyMatch((Iterable)this.val$errorTooltip.getValue(), ss -> ss.getString().equalsIgnoreCase(tooltipFilled.getString()))) continue;
                            ((List)this.val$errorTooltip.getValue()).add(colored);
                        }
                    } else {
                        ((List)this.val$errorTooltip.getValue()).add(new TranslationTextComponent("error.rei.multi.errors").func_240699_a_(TextFormatting.RED));
                        for (ITextComponent tooltipFilled : tooltipsFilled) {
                            colored = new StringTextComponent("- ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)tooltipFilled.func_230532_e_().func_240699_a_(TextFormatting.RED));
                            if (CollectionUtils.anyMatch((Iterable)this.val$errorTooltip.getValue(), ss -> ss.getString().equalsIgnoreCase(colored.getString()))) continue;
                            ((List)this.val$errorTooltip.getValue()).add(colored);
                        }
                    }
                }
                this.renderIf(true, poses, mouseX, mouseY, delta);
            }

            private void renderIf(boolean should, MatrixStack poseStack, int mouseX, int mouseY, float delta) {
                if (should) {
                    this.didJustRender = true;
                    this.widget.func_230430_a_(poseStack, mouseX, mouseY, delta);
                } else if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                    this.didJustRender = true;
                    this.widget.func_230430_a_(poseStack, mouseX, mouseY, delta);
                }
            }

            public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                if (this.didJustRender && ((Display)this.val$displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_195559_v.func_197960_a(((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.func_135052_a((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.func_135052_a((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.func_231046_a_(keyCode, scanCode, modifiers);
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (this.didJustRender && ((Display)this.val$displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.field_195559_v.func_197960_a(((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.func_135052_a((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.func_135052_a((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)this.val$displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static /* synthetic */ ITextComponent[] lambda$createAutoCraftingButtonWidget$1(Mutable errorTooltip, Supplier idsSupplier, Button button) {
        Collection locations;
        ArrayList<Object> str = new ArrayList<Object>((Collection)errorTooltip.getValue());
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
            str.add(new StringTextComponent(" "));
            for (ResourceLocation location : locations) {
                String t = I18n.func_135052_a((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                if (t.startsWith("\n")) {
                    t = t.substring("\n".length());
                }
                str.add(new StringTextComponent(t).func_240699_a_(TextFormatting.GRAY));
            }
        }
        return str.toArray(new ITextComponent[0]);
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.widgets;
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.func_231043_a_(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, ITextComponent text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, ITextProperties text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(ResourceLocation texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }
}

