/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class QueuedTooltip
implements Tooltip {
    private Point location;
    private List<ITextComponent> entries;
    private EntryStack<?> stack = EntryStack.empty();

    private QueuedTooltip(Point location, Collection<ITextComponent> entries) {
        this.location = location;
        if (this.location == null) {
            this.location = PointHelper.ofMouse();
        }
        this.entries = Lists.newArrayList(entries);
    }

    public static QueuedTooltip impl(Point location, Collection<ITextComponent> text) {
        return new QueuedTooltip(location, text);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public List<ITextComponent> getText() {
        return this.entries;
    }

    @Override
    public Tooltip add(ITextComponent text) {
        this.entries.add(text);
        return this;
    }

    @Override
    public void queue() {
        Tooltip.super.queue();
    }

    @Override
    public EntryStack<?> getContextStack() {
        return this.stack;
    }

    @Override
    public Tooltip withContextStack(EntryStack<?> stack) {
        this.stack = stack.copy();
        return this;
    }
}

