/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.animator.ValueAnimator;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Button {
    private static final ResourceLocation BUTTON_LOCATION = new ResourceLocation("roughlyenoughitems", "textures/gui/button.png");
    private static final ResourceLocation BUTTON_LOCATION_DARK = new ResourceLocation("roughlyenoughitems", "textures/gui/button_dark.png");
    private Rectangle bounds;
    private boolean enabled = true;
    private ITextComponent text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<MatrixStack, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private @Nullable Function<Button, @Nullable ITextComponent[]> tooltipFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textColorFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textureIdFunction;
    private final ValueAnimator<Color> darkBackground;

    public ButtonWidget(Rectangle rectangle, ITextComponent text) {
        this.bounds = new Rectangle(Objects.requireNonNull(rectangle));
        this.text = Objects.requireNonNull(text);
        this.darkBackground = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -1 : 0xFFFFFF)), ValueAnimator.typicalTransitionTime());
    }

    @Override
    public final boolean isFocused() {
        return this.focused;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }

    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }

    @Override
    public final void removeTint() {
        this.tint = null;
    }

    @Override
    public final ITextComponent getText() {
        return this.text;
    }

    @Override
    public final void setText(ITextComponent text) {
        this.text = text;
    }

    @Override
    @Nullable
    public final Consumer<Button> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<MatrixStack, Button> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(BiConsumer<MatrixStack, Button> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public final ITextComponent[] getTooltip() {
        if (this.tooltipFunction == null) {
            return null;
        }
        return this.tooltipFunction.apply(this);
    }

    @Override
    public final void setTooltip(@Nullable @Nullable Function<Button, @Nullable ITextComponent[]> tooltip) {
        this.tooltipFunction = tooltip;
    }

    @Override
    public final void setTextColor(@Nullable BiFunction<Button, Point, Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }

    @Override
    public final void setTextureId(@Nullable BiFunction<Button, Point, Integer> textureIdFunction) {
        this.textureIdFunction = textureIdFunction;
    }

    @Override
    public final int getTextColor(Point mouse) {
        Integer apply;
        if (this.textColorFunction != null && (apply = this.textColorFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.enabled) {
            return 0xA0A0A0;
        }
        if (this.isFocused(mouse.x, mouse.y)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.darkBackground.update(delta);
        if (this.onRender != null) {
            this.onRender.accept(matrices, this);
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        this.renderBackground(matrices, x, y, width, height, this.getTextureId(new Point(mouseX, mouseY)), false, Color.ofTransparent((int)-1));
        this.renderBackground(matrices, x, y, width, height, this.getTextureId(new Point(mouseX, mouseY)), true, (Color)this.darkBackground.value());
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.isFocused(mouseX, mouseY)) {
            color = 0xFFFFA0;
        }
        if (this.tint != null) {
            this.func_238468_a_(matrices, x + 1, y + 1, x + width - 1, y + height - 1, this.tint, this.tint);
        }
        ButtonWidget.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.font, (ITextComponent)this.getText(), (int)(x + width / 2), (int)(y + (height - 8) / 2), (int)color);
        ITextComponent[] tooltip = this.getTooltip();
        if (tooltip != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(new Point(x + width / 2, y + height / 2), tooltip).queue();
            }
        }
    }

    protected boolean isFocused(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public boolean func_231049_c__(boolean boolean_1) {
        if (!this.enabled || !this.focusable) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    @Override
    public void onClick() {
        Consumer<Button> onClick = this.getOnClick();
        if (onClick != null) {
            onClick.accept(this);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY) && this.isEnabled() && button == 0) {
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (this.isEnabled() && this.focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            }
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }

    @Override
    public final int getTextureId(Point mouse) {
        Integer apply;
        if (this.textureIdFunction != null && (apply = this.textureIdFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.containsMouse(mouse) || this.focused) {
            return 4;
        }
        return 1;
    }

    protected void renderBackground(MatrixStack matrices, int x, int y, int width, int height, int textureOffset) {
        this.renderBackground(matrices, x, y, width, height, textureOffset, REIRuntime.getInstance().isDarkThemeEnabled(), Color.ofTransparent((int)-1));
    }

    protected void renderBackground(MatrixStack matrices, int x, int y, int width, int height, int textureOffset, boolean dark, Color color) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(dark ? BUTTON_LOCATION_DARK : BUTTON_LOCATION);
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        ButtonWidget.func_238464_a_((MatrixStack)matrices, (int)x, (int)y, (int)this.func_230927_p_(), (float)0.0f, (float)(textureOffset * 80), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.func_238464_a_((MatrixStack)matrices, (int)(x + width - 8), (int)y, (int)this.func_230927_p_(), (float)248.0f, (float)(textureOffset * 80), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.func_238464_a_((MatrixStack)matrices, (int)x, (int)(y + height - 8), (int)this.func_230927_p_(), (float)0.0f, (float)(textureOffset * 80 + 72), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.func_238464_a_((MatrixStack)matrices, (int)(x + width - 8), (int)(y + height - 8), (int)this.func_230927_p_(), (float)248.0f, (float)(textureOffset * 80 + 72), (int)8, (int)8, (int)512, (int)256);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        AbstractGui.func_238461_a_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)y, (int)(y + 8), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80) / 512.0f), (float)((float)(textureOffset * 80 + 8) / 512.0f));
        AbstractGui.func_238461_a_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + height - 8), (int)(y + height), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80 + 72) / 512.0f), (float)((float)(textureOffset * 80 + 80) / 512.0f));
        AbstractGui.func_238461_a_((Matrix4f)matrix, (int)x, (int)(x + 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.0f, (float)0.03125f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
        AbstractGui.func_238461_a_((Matrix4f)matrix, (int)(x + width - 8), (int)(x + width), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.96875f, (float)1.0f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
        AbstractGui.func_238461_a_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

