/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.math.vector.Vector4f;

public class RegionEntryListEntry<T extends RegionEntry<T>>
extends EntryListEntryWidget {
    private final RealRegionEntry<T> entry;

    RegionEntryListEntry(RealRegionEntry<T> entry, int x, int y, int entrySize) {
        super(new Point(x, y), entrySize);
        this.entry = entry;
        this.clearEntries().entry(entry.getEntry().toStack());
    }

    @Override
    protected FavoriteEntry asFavoriteEntry() {
        return this.entry.region.listener.asFavorite(this.entry);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return super.containsMouse(mouseX, mouseY) && this.entry.region.containsMouse(mouseX, mouseY);
    }

    @Override
    protected boolean reverseFavoritesAction() {
        return true;
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        UUID uuid;
        ScreenOverlayImpl overlay;
        boolean isOpened;
        Optional<ScreenOverlay> overlayOptional = REIRuntime.getInstance().getOverlay();
        Optional<Supplier<Collection<FavoriteMenuEntry>>> menuEntries = this.entry.getEntry().getMenuEntries();
        FloatingPoint value = (FloatingPoint)this.entry.pos.value();
        FloatingPoint target = (FloatingPoint)this.entry.pos.target();
        if (Math.abs(value.x - target.x) < 1.0 && Math.abs(value.y - target.y) < 1.0 && overlayOptional.isPresent() && menuEntries.isPresent() && ((isOpened = (overlay = (ScreenOverlayImpl)overlayOptional.get()).isMenuOpened(uuid = this.entry.getEntry().getUuid())) || !overlay.isAnyMenuOpened())) {
            boolean inBounds;
            boolean bl = inBounds = this.containsMouse(mouseX, mouseY) || overlay.isMenuInBounds(uuid);
            if (isOpened != inBounds) {
                if (inBounds) {
                    Menu menu = new Menu(new Point(this.getBounds().x, this.getBounds().getMaxY()), CollectionUtils.map(menuEntries.get().get(), entry -> this.convertMenu(overlay, (FavoriteMenuEntry)entry)));
                    if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                        menu.menuStartPoint.x -= menu.getBounds().width - this.getBounds().width;
                    }
                    overlay.openMenu(uuid, menu, this::containsMouse, point -> this.entry.region.has(this.entry));
                } else {
                    overlay.closeOverlayMenu();
                }
            }
        }
        Vector4f vector4f = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
        vector4f.func_229372_a_(matrices.func_227866_c_().func_227870_a_());
        super.func_230430_a_(matrices, (int)vector4f.func_195910_a(), (int)vector4f.func_195913_b(), delta);
    }

    private MenuEntry convertMenu(final ScreenOverlayImpl overlay, final FavoriteMenuEntry entry) {
        return new MenuEntry(){

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.singletonList(entry);
            }

            public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
                entry.func_230430_a_(poseStack, i, j, f);
            }

            @Override
            public int getEntryWidth() {
                return entry.getEntryWidth();
            }

            @Override
            public int getEntryHeight() {
                return entry.getEntryHeight();
            }

            @Override
            public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
                entry.closeMenu = overlay::closeOverlayMenu;
                entry.updateInformation(xPos, yPos, selected, containsMouse, rendering, width);
            }

            @Override
            public int getZ() {
                return entry.getZ();
            }

            @Override
            public void setZ(int z) {
                entry.setZ(z);
            }
        };
    }

    @Override
    protected boolean doAction(double mouseX, double mouseY, int button) {
        return this.entry.getEntry().doAction(button);
    }

    public RealRegionEntry<T> getEntry() {
        return this.entry;
    }
}

