/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.architectury.event.CompoundEventResult;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.registry.screen.ExclusionZonesImpl;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ScreenRegistryImpl
implements ScreenRegistry {
    private Multimap<Class<? extends Screen>, ClickArea<?>> clickAreas = HashMultimap.create();
    private List<DraggableStackProvider<Screen>> draggableStacksProviders = new ArrayList<DraggableStackProvider<Screen>>();
    private List<DraggableStackVisitor<Screen>> draggableStacksVisitors = new ArrayList<DraggableStackVisitor<Screen>>();
    private List<FocusedStackProvider> focusedStackProviders = new ArrayList<FocusedStackProvider>();
    private List<OverlayDecider> deciders = new ArrayList<OverlayDecider>();
    private Map<Class<?>, List<OverlayDecider>> cache = new HashMap();
    private ExclusionZones exclusionZones;
    private Class<? extends Screen> tmpScreen;

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerScreens(this);
        plugin.registerExclusionZones(this.exclusionZones());
    }

    @Override
    public <R extends Screen> List<OverlayDecider> getDeciders(R screen) {
        if (screen == null) {
            return Collections.emptyList();
        }
        Class<?> screenClass = screen.getClass();
        List<OverlayDecider> possibleCached = this.cache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tmpScreen = screenClass;
        List<OverlayDecider> deciders = CollectionUtils.filterToList(this.deciders, this::filterResponsible);
        this.cache.put(screenClass, deciders);
        this.tmpScreen = null;
        return deciders;
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tmpScreen);
    }

    @Override
    public List<OverlayDecider> getDeciders() {
        return Collections.unmodifiableList(this.deciders);
    }

    @Override
    public <T extends Screen> Rectangle getScreenBounds(T screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            if (!(decider instanceof DisplayBoundsProvider)) continue;
            return ((DisplayBoundsProvider)decider).getScreenBounds(screen);
        }
        return new Rectangle();
    }

    @Override
    public <T extends Screen> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        int scaledWidth = window.func_198107_o();
        int scaledHeight = window.func_198087_p();
        Rectangle screenBounds = this.getScreenBounds(screen);
        if (screenBounds.isEmpty()) {
            return new Rectangle();
        }
        if (location == DisplayPanelLocation.LEFT) {
            if (screenBounds.x < 10) {
                return new Rectangle();
            }
            return new Rectangle(2, 0, screenBounds.x - 2, scaledHeight);
        }
        if (scaledWidth - screenBounds.getMaxX() < 10) {
            return new Rectangle();
        }
        return new Rectangle(screenBounds.getMaxX() + 2, 0, scaledWidth - screenBounds.getMaxX() - 4, scaledHeight);
    }

    @Override
    @Nullable
    public <T extends Screen> EntryStack<?> getFocusedStack(T screen, Point mouse) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            CompoundEventResult<EntryStack<?>> result = Objects.requireNonNull(provider.provide(screen, mouse));
            if (BooleanUtils.isTrue((Boolean)result.result().value())) {
                if (result != null && !((EntryStack)result.object()).isEmpty()) {
                    return (EntryStack)result.object();
                }
                return null;
            }
            if (!BooleanUtils.isFalse((Boolean)result.result().value())) continue;
            return null;
        }
        return null;
    }

    @Override
    public void registerDecider(OverlayDecider decider) {
        this.deciders.add(decider);
        this.deciders.sort(Comparator.reverseOrder());
        this.cache.clear();
        this.tmpScreen = null;
        this.registerDraggableStackProvider(DraggableStackProviderWidget.from(context -> Widgets.walk(context.getScreen().func_231039_at__(), DraggableStackProviderWidget.class::isInstance)));
        this.registerDraggableStackVisitor(DraggableStackVisitorWidget.from(context -> Widgets.walk(context.getScreen().func_231039_at__(), DraggableStackVisitorWidget.class::isInstance)));
    }

    @Override
    public void registerFocusedStack(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends Screen> void registerDraggableStackProvider(DraggableStackProvider<T> provider) {
        this.draggableStacksProviders.add(provider);
        this.draggableStacksProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends Screen> void registerDraggableStackVisitor(DraggableStackVisitor<T> visitor) {
        this.draggableStacksVisitors.add(visitor);
        this.draggableStacksVisitors.sort(Comparator.reverseOrder());
    }

    @Override
    public Iterable<DraggableStackProvider<Screen>> getDraggableProviders() {
        return Collections.unmodifiableList(this.draggableStacksProviders);
    }

    @Override
    public Iterable<DraggableStackVisitor<Screen>> getDraggableVisitors() {
        return Collections.unmodifiableList(this.draggableStacksVisitors);
    }

    @Override
    public ExclusionZones exclusionZones() {
        return this.exclusionZones;
    }

    @Override
    public <C extends Container, T extends ContainerScreen<C>> void registerContainerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screen -> {
            Rectangle rectangle = area.provide(screen).clone();
            rectangle.translate(screen.field_147003_i, screen.field_147009_r);
            return rectangle;
        }, screenClass, categories);
    }

    @Override
    public <T extends Screen> void registerClickArea(Class<? extends T> screenClass, ClickArea<T> area) {
        this.clickAreas.put(screenClass, area);
    }

    @Override
    @Nullable
    public <T extends Screen> Set<CategoryIdentifier<?>> handleClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        MutableObject categories = new MutableObject(null);
        for (ClickArea area : this.clickAreas.get(screenClass)) {
            ClickArea.Result result = area.handle(context);
            if (!result.isSuccessful()) continue;
            if (categories.getValue() == null) {
                categories.setValue(new LinkedHashSet());
            }
            result.getCategories().collect(Collectors.toCollection(() -> ((Mutable)categories).getValue()));
        }
        return (Set)categories.getValue();
    }

    @Override
    public void startReload() {
        this.clickAreas.clear();
        this.deciders.clear();
        this.cache.clear();
        this.focusedStackProviders.clear();
        this.draggableStacksProviders.clear();
        this.draggableStacksVisitors.clear();
        this.tmpScreen = null;
        this.registerDefault();
    }

    private void registerDefault() {
        this.exclusionZones = new ExclusionZonesImpl();
        this.registerDecider(this.exclusionZones);
        this.registerDecider(new OverlayDecider(){

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return true;
            }

            @Override
            public ActionResultType shouldScreenBeOverlaid(Class<?> screen) {
                return ContainerScreen.class.isAssignableFrom(screen) ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerFocusedStack(new FocusedStackProvider(){

            @Override
            public CompoundEventResult<EntryStack<?>> provide(Screen screen, Point mouse) {
                if (screen instanceof ContainerScreen) {
                    ContainerScreen containerScreen = (ContainerScreen)screen;
                    if (containerScreen.field_147006_u != null && !containerScreen.field_147006_u.func_75211_c().func_190926_b()) {
                        return CompoundEventResult.interruptTrue(EntryStacks.of(containerScreen.field_147006_u.func_75211_c()));
                    }
                }
                return CompoundEventResult.pass();
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
    }
}

